package com.gaea.iesms.bm.standalone.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaea.base.error.BizException;
import com.gaea.iesms.bm.standalone.mapper.BillingSchemeCustMapper;
import com.gaea.iesms.bm.standalone.service.BillingSchemeCustService;
import com.gaea.iesms.core.feign.request.BillingSchemeBindCustRelaRequest;
import com.gaea.iesms.core.model.entity.standalone.BillingSchemeCust;
import org.springframework.stereotype.Service;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2024/12/10
 */
@Service
public class BillingSchemeCustServiceImpl extends ServiceImpl<BillingSchemeCustMapper, BillingSchemeCust> implements BillingSchemeCustService {

    @Override
    public boolean insert(BillingSchemeBindCustRelaRequest request) {
        if (request.getCeCustId() == null || request.getSchemeId() == null) {
            throw BizException.of("schemeId 或 ceCustId 为空");
        }
        LambdaQueryWrapper<BillingSchemeCust> lambdaQueryWrapper = Wrappers.<BillingSchemeCust>lambdaQuery()
                .eq(BillingSchemeCust::getCeCustId, request.getCeCustId());
        BillingSchemeCust billingSchemeCust = getOne(lambdaQueryWrapper);
        if (billingSchemeCust == null) {
            billingSchemeCust = new BillingSchemeCust();
            billingSchemeCust.setCeCustId(request.getCeCustId());
            billingSchemeCust.setSchemeId(request.getSchemeId());
            return save(billingSchemeCust);
        }
        billingSchemeCust.setSchemeId(request.getSchemeId());
        return updateById(billingSchemeCust);
    }
}
