package com.gaea.iesms.bm.standalone.service.impl;

import cn.hutool.core.lang.Dict;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.gaea.iesms.bm.standalone.mapper.ModelSoeRecordMapper;
import com.gaea.iesms.bm.standalone.mapper.StatAlarmMapper;
import com.gaea.iesms.bm.standalone.service.StatAlarmService;
import com.gaea.iesms.core.feign.service.RemoteAlarmService;
import com.gaea.iesms.core.model.entity.alarm.SoeRecord;
import com.gaea.iesms.core.model.jsonobject.alarm.SoeGenValueJsonObject;
import com.gaea.utils.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/3/23
 */
@Service
public class StatAlarmServiceImpl implements StatAlarmService {

    private final static Logger LOGGER = LoggerFactory.getLogger(StatAlarmServiceImpl.class);

    /**
     * 默认通讯时间
     */
    private final static Long DEFAULT_COMM_TIME = 3600000L;

    @Resource
    private StatAlarmMapper statAlarmMapper;

    @Resource
    private RemoteAlarmService remoteAlarmService;

    @Resource
    private ModelSoeRecordMapper modelSoeRecordMapper;

    @Override
    public void terminalCommFaultAlarm() {
        List<Dict> list = statAlarmMapper.selectTerminalCommFaultAlarm();
        list.forEach(item -> {
            Integer alarmCount = item.getInt("alarmCount");
            if (NumberUtils.add(item.getLong("gmtMessageUp"), DEFAULT_COMM_TIME).longValue() >= System.currentTimeMillis()) {
                if (alarmCount > 0) {
                    LambdaQueryWrapper<SoeRecord> lambdaQueryWrapper = Wrappers.<SoeRecord>lambdaQuery()
                            .eq(SoeRecord::getOrgNo, item.getStr("orgNo"))
                            .eq(SoeRecord::getSoeSortNo, "SOE_TERM_COMM_FAILURE")
                            .eq(SoeRecord::getSoeObjectId, item.getLong("devTermId"))
                            .eq(SoeRecord::getIsRecovery, false);
                    SoeRecord soeRecord = modelSoeRecordMapper.selectOne(lambdaQueryWrapper);
                    if (soeRecord != null) {
                        modelSoeRecordMapper.updateById(soeRecord.setIsRecovery(true));
                    }
                }
            } else {
                if (alarmCount > 0) {
                    return;
                }
                SoeRecord soeRecord = SoeRecord.builder()
                        .orgNo(item.getStr("orgNo"))
                        .soeObjectType(1)
                        .soeObjectId(item.getLong("devTermId"))
                        .soeObjectName(item.getStr("devTermName"))
                        .soeSortNo("SOE_TERM_COMM_FAILURE")
                        .soeLevel(1)
                        .graveLevel(1)
                        .soeTitle("采集终端通讯故障")
                        .soeDesc("采集终端通讯故障")
                        .soeGenTime(new Date())
                        .soeGenValue(SoeGenValueJsonObject.builder().ceCustId(item.getLong("ceCustId")).build())
                        .isRecovery(false)
                        .isSendSms(false)
                        .sendSmsCount(0)
                        .build();
                modelSoeRecordMapper.insert(soeRecord);
            }
        });
    }

    @Override
    public void terminalGatherWarningAlarm() {
        List<Dict> list = statAlarmMapper.selectTerminalGatherWarningAlarm();
        for (Dict item : list) {
            if (item.getInt("termCommAlarmCount") > 0) {
                continue;
            }
            if (item.getInt("meterCount") <= item.getInt("meterGatherAlarmCount") && item.getInt("meterCount") != 0) {
                if (item.getInt("termGatherAlarmCount") > 0) {
                    continue;
                }
                SoeRecord soeRecord = SoeRecord.builder()
                        .orgNo(item.getStr("orgNo"))
                        .soeObjectType(1)
                        .soeObjectId(item.getLong("devTermId"))
                        .soeObjectName(item.getStr("devTermName"))
                        .soeSortNo("SOE_TERM_SOUTH_GATHER_FAILURE")
                        .soeLevel(1)
                        .graveLevel(1)
                        .soeTitle("采集终端采集故障")
                        .soeDesc("采集终端采集故障")
                        .soeGenTime(new Date())
                        .soeGenValue(SoeGenValueJsonObject.builder().ceCustId(item.getLong("ceCustId")).build())
                        .isRecovery(false)
                        .isSendSms(false)
                        .sendSmsCount(0)
                        .build();
                modelSoeRecordMapper.insert(soeRecord);
            } else {
                if (item.getInt("termGatherAlarmCount") == 0) {
                    continue;
                }
                LambdaQueryWrapper<SoeRecord> lambdaQueryWrapper = Wrappers.<SoeRecord>lambdaQuery()
                        .eq(SoeRecord::getOrgNo, item.getStr("orgNo"))
                        .eq(SoeRecord::getSoeSortNo, "SOE_TERM_SOUTH_GATHER_FAILURE")
                        .eq(SoeRecord::getSoeObjectId, item.getLong("devTermId"))
                        .eq(SoeRecord::getIsRecovery, false);
                SoeRecord soeRecord = modelSoeRecordMapper.selectOne(lambdaQueryWrapper);
                if (soeRecord != null) {
                    modelSoeRecordMapper.updateById(soeRecord.setIsRecovery(true));
                }
            }
        }
    }

    @Override
    public void meterGatherFaultAlarm() {
        List<Dict> list = statAlarmMapper.selectMeterGatherFaultAlarm();
        list.forEach(item -> {
            if (item.getInt("termAlarmCount") > 0) {
                return;
            }
            int meterAlarmCount = item.getInt("meterAlarmCount");
            if (NumberUtils.add(item.getLong("gmtMessageUp"), DEFAULT_COMM_TIME).longValue() >= System.currentTimeMillis()) {
                if (meterAlarmCount > 0) {
                    LambdaQueryWrapper<SoeRecord> lambdaQueryWrapper = Wrappers.<SoeRecord>lambdaQuery()
                            .eq(SoeRecord::getOrgNo, item.getStr("orgNo"))
                            .eq(SoeRecord::getSoeSortNo, "SOE_METER_GATHER_FAILURE")
                            .eq(SoeRecord::getSoeObjectId, item.getLong("devMeterId"))
                            .eq(SoeRecord::getIsRecovery, false);
                    SoeRecord soeRecord = modelSoeRecordMapper.selectOne(lambdaQueryWrapper);
                    if (soeRecord != null) {
                        modelSoeRecordMapper.updateById(soeRecord.setIsRecovery(true));
                    }
                }
            } else {
                if (meterAlarmCount > 0) {
                    return;
                }
                SoeRecord soeRecord = SoeRecord.builder()
                        .orgNo(item.getStr("orgNo"))
                        .soeObjectType(3)
                        .soeObjectId(item.getLong("devMeterId"))
                        .soeObjectName(item.getStr("devMeterName"))
                        .soeSortNo("SOE_METER_GATHER_FAILURE")
                        .soeLevel(1)
                        .graveLevel(1)
                        .soeTitle("量测表计采集故障")
                        .soeDesc("量测表计采集故障")
                        .soeGenTime(new Date())
                        .soeGenValue(SoeGenValueJsonObject.builder().ceCustId(item.getLong("ceCustId")).build())
                        .isRecovery(false)
                        .isSendSms(false)
                        .sendSmsCount(0)
                        .build();
                modelSoeRecordMapper.insert(soeRecord);
            }
        });
    }

    @Override
    public void inverterBusTripAlarm() {
        BigDecimal zero = BigDecimal.ZERO;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int hour = calendar.get(Calendar.HOUR_OF_DAY);
        int minute = calendar.get(Calendar.MINUTE);
        int index = hour * 4 + minute / 15 + 1;
        List<Dict> list = statAlarmMapper.selectInverterBusTripAlarm();
        for (Dict item : list) {
            if (item.getInt("termCount") <= item.getInt("termAlarmCount")) {
                continue;
            }
            // 负荷值
            BigDecimal eloadValue1 = item.get("eloadValue" + index, zero);
            BigDecimal eloadValue2 = item.get("eloadValue" + (index - 1), zero);
            BigDecimal eloadValue3 = item.get("eloadValue" + (index - 2), zero);
            BigDecimal eloadValue4 = item.get("eloadValue" + (index - 3), zero);
            // 电量值
            BigDecimal econsValue1 = item.get("econsValue" + index, zero);
            BigDecimal econsValue2 = item.get("econsValue" + (index - 1), zero);
            BigDecimal econsValue3 = item.get("econsValue" + (index - 2), zero);
            BigDecimal econsValue4 = item.get("econsValue" + (index - 3), zero);

            if (NumberUtils.equals(zero, eloadValue1) && NumberUtils.equals(eloadValue1, eloadValue2) && NumberUtils.equals(eloadValue2, eloadValue3) && NumberUtils.equals(eloadValue3, eloadValue4)) {
                if (NumberUtils.equals(zero, econsValue1) && NumberUtils.equals(econsValue1, econsValue2) && NumberUtils.equals(econsValue2, econsValue3) && NumberUtils.equals(econsValue3, econsValue4)) {
                    if (item.getInt("alarmCount") > 0) {
                        continue;
                    }
                    SoeRecord soeRecord = SoeRecord.builder()
                            .orgNo(item.getStr("orgNo"))
                            .soeObjectType(20)
                            .soeObjectId(item.getLong("ceDeviceId"))
                            .soeObjectName(item.getStr("ceResName"))
                            .soeSortNo("SOE_DEV_PV_INVERTER_BUS_TRIP_ALARM")
                            .soeLevel(1)
                            .graveLevel(1)
                            .soeTitle("逆变器总线跳闸")
                            .soeDesc("逆变器总线跳闸")
                            .soeGenTime(new Date())
                            .soeGenValue(SoeGenValueJsonObject.builder().ceCustId(item.getLong("ceCustId")).build())
                            .isRecovery(false)
                            .isSendSms(false)
                            .sendSmsCount(0)
                            .build();
                    modelSoeRecordMapper.insert(soeRecord);
                    continue;
                }
            }
            if (item.getInt("alarmCount") == 0) {
                continue;
            }
            LambdaQueryWrapper<SoeRecord> lambdaQueryWrapper = Wrappers.<SoeRecord>lambdaQuery()
                    .eq(SoeRecord::getOrgNo, item.getStr("orgNo"))
                    .eq(SoeRecord::getSoeSortNo, "SOE_DEV_PV_INVERTER_BUS_TRIP_ALARM")
                    .eq(SoeRecord::getSoeObjectId, item.getLong("ceDeviceId"))
                    .eq(SoeRecord::getIsRecovery, false);
            SoeRecord soeRecord = modelSoeRecordMapper.selectOne(lambdaQueryWrapper);
            if (soeRecord != null) {
                modelSoeRecordMapper.updateById(soeRecord.setIsRecovery(true));
            }
        }
    }
}
