package com.gaea.iesms.bm.standalone.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.gaea.iesms.bm.standalone.mapper.StatCecntrEconsDayMapper;
import com.gaea.iesms.bm.standalone.mapper.StatCecntrEconsMonthMapper;
import com.gaea.iesms.bm.standalone.mapper.StatCecntrEconsYearMapper;
import com.gaea.iesms.bm.standalone.service.StatCecntrEconsService;
import com.gaea.iesms.core.model.entity.standalone.StatCecntrEconsDay;
import com.gaea.iesms.core.model.entity.standalone.StatCecntrEconsMonth;
import com.gaea.iesms.core.model.entity.standalone.StatCecntrEconsYear;
import com.gaea.utils.DateUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2024/12/30
 */
@Service
public class StatCecntrEconsServiceImpl implements StatCecntrEconsService {

    @Resource
    private StatCecntrEconsDayMapper statCecntrEconsDayMapper;

    @Resource
    private StatCecntrEconsMonthMapper statCecntrEconsMonthMapper;

    @Resource
    private StatCecntrEconsYearMapper statCecntrEconsYearMapper;

    @Override
    public Map<String, Map<String, BigDecimal>> getRangeDay(List<String> keys, String start, String end, Function<StatCecntrEconsDay, BigDecimal> mapper) {
        LambdaQueryWrapper<StatCecntrEconsDay> lambdaQueryWrapper = Wrappers.<StatCecntrEconsDay>lambdaQuery()
                .in(StatCecntrEconsDay::getCeCntrId, keys)
                .between(StatCecntrEconsDay::getDateStat, start, end);
        List<StatCecntrEconsDay> days = statCecntrEconsDayMapper.selectList(lambdaQueryWrapper);
        return days.stream().collect(Collectors.groupingBy(item -> item.getCeCntrId().toString(), Collectors.toMap(item -> DateUtils.formatDate(item.getDateStat()), mapper)));
    }

    @Override
    public Map<String, Map<String, BigDecimal>> getRangeMonth(List<String> keys, String start, String end, Function<StatCecntrEconsMonth, BigDecimal> mapper) {
        LambdaQueryWrapper<StatCecntrEconsMonth> lambdaQueryWrapper = Wrappers.<StatCecntrEconsMonth>lambdaQuery()
                .in(StatCecntrEconsMonth::getCeCntrId, keys)
                .between(StatCecntrEconsMonth::getMonthStat, start.replace("-", ""), end.replace("-", ""));
        List<StatCecntrEconsMonth> months = statCecntrEconsMonthMapper.selectList(lambdaQueryWrapper);
        return months.stream().collect(Collectors.groupingBy(item -> item.getCeCntrId().toString(), Collectors.toMap(item -> item.getMonthStat().toString(), mapper)));
    }

    @Override
    public Map<String, Map<String, BigDecimal>> getRangeYear(List<String> keys, String start, String end, Function<StatCecntrEconsYear, BigDecimal> mapper) {
        LambdaQueryWrapper<StatCecntrEconsYear> lambdaQueryWrapper = Wrappers.<StatCecntrEconsYear>lambdaQuery()
                .in(StatCecntrEconsYear::getCeCntrId, keys)
                .between(StatCecntrEconsYear::getYearStat, start, end);
        List<StatCecntrEconsYear> years = statCecntrEconsYearMapper.selectList(lambdaQueryWrapper);
        return years.stream().collect(Collectors.groupingBy(item -> item.getCeCntrId().toString(), Collectors.toMap(item -> item.getYearStat().toString(), mapper)));
    }
}
