package com.gaea.iesms.bm.standalone.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.standalone.mapper.*;
import com.gaea.iesms.bm.standalone.model.dto.StatisticsDateDTO;
import com.gaea.iesms.bm.standalone.model.dto.StatisticsDayDateDTO;
import com.gaea.iesms.bm.standalone.model.dto.StatisticsMonthDateDTO;
import com.gaea.iesms.bm.standalone.model.dto.StatisticsYearDateDTO;
import com.gaea.iesms.bm.standalone.model.vo.ContainerInfoVo;
import com.gaea.iesms.bm.standalone.service.StatEconsService;
import com.gaea.iesms.bm.standalone.util.StatisticsDataUtils;
import com.gaea.iesms.core.feign.dto.SysOrg;
import com.gaea.iesms.core.feign.dto.SysOrgQueryResponse;
import com.gaea.iesms.core.feign.request.SysOrgQueryRequest;
import com.gaea.iesms.core.feign.request.datacenter.MeasStatCumDayGetRequest;
import com.gaea.iesms.core.feign.response.datacenter.MeasStatCumDayGetResponse;
import com.gaea.iesms.core.feign.response.datacenter.MeasStatCumDayValue;
import com.gaea.iesms.core.feign.service.DataCenterCommonService;
import com.gaea.iesms.core.feign.service.RemoteSystemService;
import com.gaea.iesms.core.model.entity.standalone.*;
import com.gaea.iesms.core.model.entity.standalone.view.ViewPoint;
import com.gaea.iesms.core.model.jsonobject.standalone.BillingSchemeTemplateParamsDegreeJsonObject;
import com.gaea.iesms.core.model.jsonobject.standalone.BillingSchemeTemplateParamsDegreePeriodJsonObject;
import com.gaea.iesms.core.model.jsonobject.standalone.StatCepointEconsDayDevMeterInfoJsonObject;
import com.gaea.utils.JsonUtils;
import com.gaea.utils.NumberUtils;
import com.gaea.utils.ObjectUtils;
import com.gaea.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/4/25
 */
@Service
public class StatEconsServiceImpl implements StatEconsService {

    private static final Logger LOGGER = LoggerFactory.getLogger(StatEconsServiceImpl.class);
    private static final String GEN_WATT_PAET = "gen_watt_paet";
    private static final String GEN_WATT_PAE1 = "gen_watt_pae1";
    private static final String GEN_WATT_PAE2 = "gen_watt_pae2";
    private static final String GEN_WATT_PAE3 = "gen_watt_pae3";
    private static final String GEN_WATT_PAE4 = "gen_watt_pae4";
    private static final Set<String> ITEM_CODE_SET = CollectionUtil.newHashSet(GEN_WATT_PAET, GEN_WATT_PAE1, GEN_WATT_PAE2, GEN_WATT_PAE3, GEN_WATT_PAE4);

    @Resource
    private StatEconsSelectMapper statEconsSelectMapper;

    @Resource
    private StatSelectMapper statSelectMapper;

    @Resource
    private DataCenterCommonService dataCenterCommonService;

    @Resource
    private StatEconsInsertMapper statEconsInsertMapper;

    @Resource
    private StatCecntrEconsDayMapper statCecntrEconsDayMapper;

    @Resource
    private ViewPointMapper viewPointMapper;

    @Resource
    private RemoteSystemService remoteSystemService;

    @Resource
    private StatCepointEconsYearMapper statCepointEconsYearMapper;

    @Resource
    private StatCecntrEconsYearMapper statCecntrEconsYearMapper;

    @Resource
    private StatCeresAccumMapper statCeresAccumMapper;

    @Resource
    private StatCedeviceEconsYearMapper statCedeviceEconsYearMapper;

    @Override
    public void startPointDayJob(StatisticsDateDTO dateDTO) {
        StatisticsDayDateDTO dayDateDTO = dateDTO.getDayDateDTO();
        List<StatCepointEconsDay> dayList = new ArrayList<>();
        Map<Long, List<ViewPoint>> selectList = viewPointMapper.selectList(Wrappers.lambdaQuery()).stream().collect(Collectors.groupingBy(ViewPoint::getCePointId));
        selectList.forEach((cePointId, pointInfoVoList) -> {
            Dict curve = Dict.create();

            List<StatCepointEconsDayDevMeterInfoJsonObject> meterJsonList = new ArrayList<>();
            StatCepointEconsDay day = StatCepointEconsDay.builder()
                    .orgNo(pointInfoVoList.get(0).getOrgNo())
                    .ceCustId(pointInfoVoList.get(0).getCeCustId())
                    .cePointId(pointInfoVoList.get(0).getCePointId())
                    .dateStat(dayDateDTO.getStart())
                    .schemeId(pointInfoVoList.get(0).getSchemeId())
                    .tmplParams(JsonUtils.toJsonStr(pointInfoVoList.get(0).getTmplParams()))
                    .build();

            // TODO 存在多块表的情况
            for (ViewPoint pointInfoVo : pointInfoVoList) {

                MeasStatCumDayGetRequest request = new MeasStatCumDayGetRequest();
                request.setMeasPointId(pointInfoVo.getMeasPointId());
                request.setDateMeasStat(dayDateDTO.getDate());
                request.setMeasDataSideType(1);
                request.setMeasItemCodeSet(ITEM_CODE_SET);
                R<MeasStatCumDayGetResponse> response = dataCenterCommonService.getMeasStatCumDay(request);

                if (!response.isSuccess()) {
                    continue;
                }

                StatCepointEconsDayDevMeterInfoJsonObject meterJson = new StatCepointEconsDayDevMeterInfoJsonObject();
                meterJson.setDevMeterId(pointInfoVo.getDevMeterId());
                meterJson.setDevMeterNo(pointInfoVo.getDevMeterNo());
                meterJson.setDevMeterName(pointInfoVo.getDevMeterName());
                meterJson.setDevMeterCommProto(pointInfoVo.getDevMeterCommProto());
                meterJson.setDevMeterCommAddr(pointInfoVo.getDevMeterCommAddr());
                meterJson.setAccessGatewayId(pointInfoVo.getAccessGatewayId());
                meterJson.setMeasPointId(pointInfoVo.getMeasPointId());
                meterJson.setSelfRate(pointInfoVo.getSelfRate());
                meterJson.setCtRate(pointInfoVo.getCtRate());
                meterJson.setPtRate(pointInfoVo.getPtRate());
                Map<String, MeasStatCumDayValue> measStatMap = response.getData().getMeasStatMap();
                BillingSchemeTemplateParamsDegreeJsonObject degreeJsonObject = JsonUtils.parseObj(pointInfoVo.getTmplParams()).toBean(BillingSchemeTemplateParamsDegreeJsonObject.class);

                // TODO 日总电量处理
                MeasStatCumDayValue value = measStatMap.get(GEN_WATT_PAET);
                if (value != null && value.getUsageDval() != null) {
                    for (int i = 0; i < value.getUsageQvals().length; i++) {
                        String name = "econsValue" + StringUtils.fillZero(i + 1, 2);
                        curve.put(name, StatisticsDataUtils.addBigDecimal(curve.getBigDecimal(name), value.getUsageQvals()[i]));
                    }

                    day.setStartEconsTimeDay(new Date(value.getGmtStartDval()));
                    day.setEndEconsTimeDay(new Date(value.getGmtEndDval()));

                    meterJson.setEconsValueDay(value.getUsageDval());
                    meterJson.setStartEconsValueDay(value.getStartDval());
                    meterJson.setEndEconsValueDay(value.getEndDval());
                    meterJson.setStartEconsTimeDay(DateUtil.format(new Date(value.getGmtStartDval()), DatePattern.NORM_DATETIME_PATTERN));
                    meterJson.setEndEconsTimeDay(DateUtil.format(new Date(value.getGmtEndDval()), DatePattern.NORM_DATETIME_PATTERN));

                    if (degreeJsonObject != null && StringUtils.equals(degreeJsonObject.getPriceRateType(), "single")) {
                        meterJson.setExpenseDay(NumberUtils.mulBigDecimal(day.getEconsValueDay(), degreeJsonObject.getPriceTotal()));
                    }
                } else {
                    continue;
                }

                if (degreeJsonObject == null || StringUtils.equals(degreeJsonObject.getPriceRateType(), "multi")) {
                    // TODO 日尖电量处理
                    MeasStatCumDayValue value1 = measStatMap.get(GEN_WATT_PAE1);
                    if (value1 != null) {
                        meterJson.setEconsValueDr1(value1.getUsageDval());
                        meterJson.setStartEconsValueDr1(value1.getStartDval());
                        meterJson.setEndEconsValueDr1(value1.getEndDval());
                    }
                    // TODO 日峰电量处理
                    MeasStatCumDayValue value2 = measStatMap.get(GEN_WATT_PAE2);
                    if (value2 != null) {
                        meterJson.setEconsValueDr2(value2.getUsageDval());
                        meterJson.setStartEconsValueDr2(value2.getStartDval());
                        meterJson.setEndEconsValueDr2(value2.getEndDval());
                    }
                    // TODO 日平电量处理
                    MeasStatCumDayValue value3 = measStatMap.get(GEN_WATT_PAE3);
                    if (value3 != null) {
                        meterJson.setEconsValueDr3(value3.getUsageDval());
                        meterJson.setStartEconsValueDr3(value3.getStartDval());
                        meterJson.setEndEconsValueDr3(value3.getEndDval());
                    }
                    // TODO 日谷电量处理
                    MeasStatCumDayValue value4 = measStatMap.get(GEN_WATT_PAE4);
                    if (value4 != null) {
                        meterJson.setEconsValueDr4(value4.getUsageDval());
                        meterJson.setStartEconsValueDr4(value4.getStartDval());
                        meterJson.setEndEconsValueDr4(value4.getEndDval());
                    }

                    Optional.ofNullable(degreeJsonObject).ifPresent(degree -> {
                        meterJson.setExpenseDr1(NumberUtils.addBigDecimal(meterJson.getEconsValueDr1(), degree.getPriceRate1()));
                        meterJson.setExpenseDr2(NumberUtils.addBigDecimal(meterJson.getEconsValueDr2(), degree.getPriceRate2()));
                        meterJson.setExpenseDr3(NumberUtils.addBigDecimal(meterJson.getEconsValueDr3(), degree.getPriceRate3()));
                        meterJson.setExpenseDr4(NumberUtils.addBigDecimal(meterJson.getEconsValueDr4(), degree.getPriceRate4()));
                        meterJson.setExpenseDay(NumberUtils.addBigDecimal(meterJson.getExpenseDr1(), meterJson.getExpenseDr2(), meterJson.getExpenseDr3(), meterJson.getExpenseDr4()));
                    });
                } else if (StringUtils.equals(degreeJsonObject.getPriceRateType(), "custommulti")) {

                    Map<Integer, Integer> indexMap = new HashMap<>();

                    List<BillingSchemeTemplateParamsDegreePeriodJsonObject> periodList = degreeJsonObject.getPeriodList();
                    for (BillingSchemeTemplateParamsDegreePeriodJsonObject period : periodList) {
                        String[] startPeriods = period.getStartPeriod().split(":");
                        String[] endPeriods = period.getEndPeriod().split(":");

                        int startIndex = Integer.parseInt(startPeriods[0]) * 4 + Integer.parseInt(startPeriods[1]) / 15 + 1;
                        int endIndex = Integer.parseInt(endPeriods[0]) * 4 + Integer.parseInt(endPeriods[1]) / 15 + 1;

                        for (int i = startIndex; i < endIndex; i++) {
                            indexMap.put(i, period.getPeriodNumber());
                            if (i == 95) {
                                indexMap.put(i + 1, period.getPeriodNumber());
                            }
                        }
                    }

                    AtomicReference<BigDecimal> econsValueDr1 = new AtomicReference<>(null);
                    AtomicReference<BigDecimal> econsValueDr2 = new AtomicReference<>(null);
                    AtomicReference<BigDecimal> econsValueDr3 = new AtomicReference<>(null);
                    AtomicReference<BigDecimal> econsValueDr4 = new AtomicReference<>(null);
                    indexMap.forEach((key, val) -> {
                        String name = "econsValue" + StringUtils.fillZero(key, 2);
                        BigDecimal bigDecimal = curve.getBigDecimal(name);

                        switch (val) {
                            case 1:
                                econsValueDr1.set(NumberUtils.addBigDecimal(econsValueDr1.get(), bigDecimal));
                                break;
                            case 2:
                                econsValueDr2.set(NumberUtils.addBigDecimal(econsValueDr2.get(), bigDecimal));
                                break;
                            case 3:
                                econsValueDr3.set(NumberUtils.addBigDecimal(econsValueDr3.get(), bigDecimal));
                                break;
                            case 4:
                                econsValueDr4.set(NumberUtils.addBigDecimal(econsValueDr4.get(), bigDecimal));
                                break;
                        }
                    });

                    meterJson.setEconsValueDr1(econsValueDr1.get());
                    meterJson.setEconsValueDr2(econsValueDr2.get());
                    meterJson.setEconsValueDr3(econsValueDr3.get());
                    meterJson.setEconsValueDr4(econsValueDr4.get());
                    meterJson.setExpenseDr1(NumberUtils.mulBigDecimal(meterJson.getEconsValueDr1(), degreeJsonObject.getPriceRate1()));
                    meterJson.setExpenseDr2(NumberUtils.mulBigDecimal(meterJson.getEconsValueDr2(), degreeJsonObject.getPriceRate2()));
                    meterJson.setExpenseDr3(NumberUtils.mulBigDecimal(meterJson.getEconsValueDr3(), degreeJsonObject.getPriceRate3()));
                    meterJson.setExpenseDr4(NumberUtils.mulBigDecimal(meterJson.getEconsValueDr4(), degreeJsonObject.getPriceRate4()));
                    meterJson.setExpenseDay(NumberUtils.addBigDecimal(meterJson.getExpenseDr1(), meterJson.getExpenseDr2(), meterJson.getExpenseDr3(), meterJson.getExpenseDr4()));
                }
                meterJsonList.add(meterJson);
            }
            if (meterJsonList.isEmpty()) {
                return;
            }

            day.setStartEconsValueDay(NumberUtils.addBigDecimal(meterJsonList.stream().map(StatCepointEconsDayDevMeterInfoJsonObject::getStartEconsValueDay).collect(Collectors.toList())));
            day.setEndEconsValueDay(NumberUtils.addBigDecimal(meterJsonList.stream().map(StatCepointEconsDayDevMeterInfoJsonObject::getEndEconsValueDay).collect(Collectors.toList())));
            day.setEconsValueDay(NumberUtils.addBigDecimal(meterJsonList.stream().map(StatCepointEconsDayDevMeterInfoJsonObject::getEconsValueDay).collect(Collectors.toList())));
            day.setEconsValueDr1(NumberUtils.addBigDecimal(meterJsonList.stream().map(StatCepointEconsDayDevMeterInfoJsonObject::getEconsValueDr1).collect(Collectors.toList())));
            day.setEconsValueDr2(NumberUtils.addBigDecimal(meterJsonList.stream().map(StatCepointEconsDayDevMeterInfoJsonObject::getEconsValueDr2).collect(Collectors.toList())));
            day.setEconsValueDr3(NumberUtils.addBigDecimal(meterJsonList.stream().map(StatCepointEconsDayDevMeterInfoJsonObject::getEconsValueDr3).collect(Collectors.toList())));
            day.setEconsValueDr4(NumberUtils.addBigDecimal(meterJsonList.stream().map(StatCepointEconsDayDevMeterInfoJsonObject::getEconsValueDr4).collect(Collectors.toList())));
            day.setExpenseDay(NumberUtils.addBigDecimal(meterJsonList.stream().map(StatCepointEconsDayDevMeterInfoJsonObject::getExpenseDay).collect(Collectors.toList())));
            day.setExpenseDr1(NumberUtils.addBigDecimal(meterJsonList.stream().map(StatCepointEconsDayDevMeterInfoJsonObject::getExpenseDr1).collect(Collectors.toList())));
            day.setExpenseDr2(NumberUtils.addBigDecimal(meterJsonList.stream().map(StatCepointEconsDayDevMeterInfoJsonObject::getExpenseDr2).collect(Collectors.toList())));
            day.setExpenseDr3(NumberUtils.addBigDecimal(meterJsonList.stream().map(StatCepointEconsDayDevMeterInfoJsonObject::getExpenseDr3).collect(Collectors.toList())));
            day.setExpenseDr4(NumberUtils.addBigDecimal(meterJsonList.stream().map(StatCepointEconsDayDevMeterInfoJsonObject::getExpenseDr4).collect(Collectors.toList())));

            ObjectUtils.copyProperties(curve, day);

            JSONObject jsonObject = new JSONObject();
            jsonObject.set("meterList", meterJsonList);

            day.setDevMeterInfo(jsonObject.toString());
            dayList.add(day);
        });
        if (dayList.size() > 0) {
            StatisticsDataUtils.initData(dayList);
            statEconsInsertMapper.batchInsertOrUpdateStatCepointEconsDay(dayList);
        }
        // TODO 月
        startPointMonthJob(dateDTO.getMonthDateDTO());
        // TODO 年
        startPointYearJob(dateDTO.getYearDateDTO());
    }

    @Override
    public void startPointMonthJob(StatisticsMonthDateDTO dateDTO) {
        List<StatCepointEconsMonth> dataList = statEconsSelectMapper.selectCePointMonth(dateDTO.getStart(), dateDTO.getEnd());
        if (dataList.size() == 0) {
            return;
        }
        statEconsInsertMapper.batchInsertOrUpdateStatCepointEconsMonth(StatisticsDataUtils.initData(dataList));
    }

    @Override
    public void startPointYearJob(StatisticsYearDateDTO dateDTO) {
        List<StatCepointEconsYear> dataList = statEconsSelectMapper.selectCePointYear(dateDTO.getStart(), dateDTO.getEnd());
        if (dataList.size() == 0) {
            return;
        }
        statEconsInsertMapper.batchInsertOrUpdateStatCepointEconsYear(StatisticsDataUtils.initData(dataList));

        // TODO 累计
        LambdaQueryWrapper<StatCepointEconsYear> lambdaQueryWrapper = Wrappers.<StatCepointEconsYear>lambdaQuery()
                .select(StatCepointEconsYear::getCePointId, StatCepointEconsYear::getOrgNo,
                        StatCepointEconsYear::getEconsValueYear, StatCepointEconsYear::getEconsValueYr1, StatCepointEconsYear::getEconsValueYr2, StatCepointEconsYear::getEconsValueYr3, StatCepointEconsYear::getEconsValueYr4,
                        StatCepointEconsYear::getExpenseYear, StatCepointEconsYear::getExpenseYr1, StatCepointEconsYear::getExpenseYr2, StatCepointEconsYear::getExpenseYr3, StatCepointEconsYear::getExpenseYr4)
                .isNotNull(StatCepointEconsYear::getEconsValueYear);
        List<StatCepointEconsYear> yearList = statCepointEconsYearMapper.selectList(lambdaQueryWrapper);
        if (yearList.isEmpty()) {
            return;
        }
        List<StatCeresAccum> accumList = new ArrayList<>();
        Map<Long, List<StatCepointEconsYear>> collect = yearList.stream().collect(Collectors.groupingBy(StatCepointEconsYear::getCePointId));
        collect.forEach((cePointId, list) -> {
            StatCeresAccum accum = new StatCeresAccum();
            accum.setId(cePointId);
            accum.setOrgNo(list.get(0).getOrgNo());
            accum.setCeResClass(5);
            accum.setGmtCreate(System.currentTimeMillis());
            accum.setGmtModified(System.currentTimeMillis());
            accum.setEconsValueAccum(NumberUtils.addBigDecimal(list.stream().map(StatCepointEconsYear::getEconsValueYear).collect(Collectors.toList())));
            accum.setEconsValueAr1(NumberUtils.addBigDecimal(list.stream().map(StatCepointEconsYear::getEconsValueYr1).collect(Collectors.toList())));
            accum.setEconsValueAr2(NumberUtils.addBigDecimal(list.stream().map(StatCepointEconsYear::getEconsValueYr2).collect(Collectors.toList())));
            accum.setEconsValueAr3(NumberUtils.addBigDecimal(list.stream().map(StatCepointEconsYear::getEconsValueYr3).collect(Collectors.toList())));
            accum.setEconsValueAr4(NumberUtils.addBigDecimal(list.stream().map(StatCepointEconsYear::getEconsValueYr4).collect(Collectors.toList())));
            accum.setExpenseAccum(NumberUtils.addBigDecimal(list.stream().map(StatCepointEconsYear::getExpenseYear).collect(Collectors.toList())));
            accum.setExpenseAr1(NumberUtils.addBigDecimal(list.stream().map(StatCepointEconsYear::getExpenseYr1).collect(Collectors.toList())));
            accum.setExpenseAr2(NumberUtils.addBigDecimal(list.stream().map(StatCepointEconsYear::getExpenseYr2).collect(Collectors.toList())));
            accum.setExpenseAr3(NumberUtils.addBigDecimal(list.stream().map(StatCepointEconsYear::getExpenseYr3).collect(Collectors.toList())));
            accum.setExpenseAr4(NumberUtils.addBigDecimal(list.stream().map(StatCepointEconsYear::getExpenseYr4).collect(Collectors.toList())));
            accumList.add(accum);
        });
        statCeresAccumMapper.batchInsertOrUpdateStatCeresAccum(accumList);
    }

    @Override
    public void startDeviceDayJob(StatisticsDateDTO dateDTO) {
        List<StatCedeviceEconsDay> dataList = statEconsSelectMapper.selectCeDevicePointDay(dateDTO.getDayDateDTO().getStart());
        if (dataList.size() > 0) {
            statEconsInsertMapper.batchInsertOrUpdateStatCedeviceEconsDay(StatisticsDataUtils.initData(dataList));
        }
        // TODO 月
        startDeviceMonthJob(dateDTO.getMonthDateDTO());
        // TODO 年
        startDeviceYearJob(dateDTO.getYearDateDTO());
    }

    @Override
    public void startDeviceMonthJob(StatisticsMonthDateDTO dateDTO) {
        List<StatCedeviceEconsMonth> dataList = statEconsSelectMapper.selectCeDeviceMonth(dateDTO.getStart(), dateDTO.getEnd());
        if (dataList.size() == 0) {
            return;
        }
        statEconsInsertMapper.batchInsertOrUpdateStatCedeviceEconsMonth(StatisticsDataUtils.initData(dataList));
    }

    @Override
    public void startDeviceYearJob(StatisticsYearDateDTO dateDTO) {
        List<StatCedeviceEconsYear> dataList = statEconsSelectMapper.selectCeDeviceYear(dateDTO.getStart(), dateDTO.getEnd());
        if (dataList.size() == 0) {
            return;
        }
        statEconsInsertMapper.batchInsertOrUpdateStatCedeviceEconsYear(StatisticsDataUtils.initData(dataList));

        // TODO 累计
        LambdaQueryWrapper<StatCedeviceEconsYear> lambdaQueryWrapper = Wrappers.<StatCedeviceEconsYear>lambdaQuery()
                .select(StatCedeviceEconsYear::getCeDeviceId, StatCedeviceEconsYear::getEqHoursYear, StatCedeviceEconsYear::getOrgNo,
                        StatCedeviceEconsYear::getEconsValueYear, StatCedeviceEconsYear::getEconsValueYr1, StatCedeviceEconsYear::getEconsValueYr2, StatCedeviceEconsYear::getEconsValueYr3, StatCedeviceEconsYear::getEconsValueYr4,
                        StatCedeviceEconsYear::getExpenseYear, StatCedeviceEconsYear::getExpenseYr1, StatCedeviceEconsYear::getExpenseYr2, StatCedeviceEconsYear::getExpenseYr3, StatCedeviceEconsYear::getExpenseYr4)
                .isNotNull(StatCedeviceEconsYear::getEconsValueYear);
        List<StatCedeviceEconsYear> yearList = statCedeviceEconsYearMapper.selectList(lambdaQueryWrapper);
        if (yearList.isEmpty()) {
            return;
        }
        List<StatCeresAccum> accumList = new ArrayList<>();
        Map<Long, List<StatCedeviceEconsYear>> collect = yearList.stream().collect(Collectors.groupingBy(StatCedeviceEconsYear::getCeDeviceId));
        collect.forEach((ceDeviceId, list) -> {
            StatCeresAccum accum = new StatCeresAccum();
            accum.setId(ceDeviceId);
            accum.setOrgNo(list.get(0).getOrgNo());
            accum.setCeResClass(4);
            accum.setGmtCreate(System.currentTimeMillis());
            accum.setGmtModified(System.currentTimeMillis());
            accum.setEconsValueAccum(NumberUtils.addBigDecimal(list.stream().map(StatCedeviceEconsYear::getEconsValueYear).collect(Collectors.toList())));
            accum.setEconsValueAr1(NumberUtils.addBigDecimal(list.stream().map(StatCedeviceEconsYear::getEconsValueYr1).collect(Collectors.toList())));
            accum.setEconsValueAr2(NumberUtils.addBigDecimal(list.stream().map(StatCedeviceEconsYear::getEconsValueYr2).collect(Collectors.toList())));
            accum.setEconsValueAr3(NumberUtils.addBigDecimal(list.stream().map(StatCedeviceEconsYear::getEconsValueYr3).collect(Collectors.toList())));
            accum.setEconsValueAr4(NumberUtils.addBigDecimal(list.stream().map(StatCedeviceEconsYear::getEconsValueYr4).collect(Collectors.toList())));
            accum.setExpenseAccum(NumberUtils.addBigDecimal(list.stream().map(StatCedeviceEconsYear::getExpenseYear).collect(Collectors.toList())));
            accum.setExpenseAr1(NumberUtils.addBigDecimal(list.stream().map(StatCedeviceEconsYear::getExpenseYr1).collect(Collectors.toList())));
            accum.setExpenseAr2(NumberUtils.addBigDecimal(list.stream().map(StatCedeviceEconsYear::getExpenseYr2).collect(Collectors.toList())));
            accum.setExpenseAr3(NumberUtils.addBigDecimal(list.stream().map(StatCedeviceEconsYear::getExpenseYr3).collect(Collectors.toList())));
            accum.setExpenseAr4(NumberUtils.addBigDecimal(list.stream().map(StatCedeviceEconsYear::getExpenseYr4).collect(Collectors.toList())));
            accum.setEqHoursAccum(NumberUtils.addBigDecimal(list.stream().map(StatCedeviceEconsYear::getEqHoursYear).collect(Collectors.toList())));
            accumList.add(accum);
        });
        statCeresAccumMapper.batchInsertOrUpdateStatCeresAccum(accumList);
    }

    @Override
    public void startContainerDayJob(StatisticsDateDTO dateDTO) {
        StatisticsDayDateDTO dayDateDTO = dateDTO.getDayDateDTO();
        List<StatCecntrEconsDay> dataList = statEconsSelectMapper.selectCeContainerPointDay(dayDateDTO.getStart());
        List<Long> idList = dataList.stream().map(StatCecntrEconsDay::getCeCntrId).collect(Collectors.toList());
        List<ContainerInfoVo> containerAll = statSelectMapper.selectContainerAll().stream().filter(item -> !idList.contains(item.getId())).collect(Collectors.toList());
        Map<Long, StatCecntrEconsDay> deviceMap = new HashMap<>();
        for (ContainerInfoVo item : containerAll) {
            if (item.getMeterCount() > 0) {
                StatCecntrEconsDay day = statEconsSelectMapper.selectCeContainerMeterDay(item.getId(), dayDateDTO.getDate());
                if (day != null) {
                    dataList.add(day);
                }
            } else {
                StatCecntrEconsDay day = statEconsSelectMapper.selectCeContainerDeviceDay(item.getId(), dayDateDTO.getDate());
                if (day != null) {
                    dataList.add(day);
                    deviceMap.put(item.getId(), day);
                }
            }
        }
        dataList = dataList.stream().filter(item -> item.getEconsValueDay() != null).collect(Collectors.toList());
        if (dataList.size() > 0) {
            statEconsInsertMapper.batchInsertOrUpdateStatCecntrEconsDay(StatisticsDataUtils.initData(dataList));
        }
        dataList = statEconsSelectMapper.selectCeContainerParentDay(dayDateDTO.getDate());
        for (StatCecntrEconsDay item : dataList) {
            StatCecntrEconsDay day = deviceMap.get(item.getCeCntrId());
            if (day == null) {
                LambdaQueryWrapper<StatCecntrEconsDay> lambdaQueryWrapper = Wrappers.<StatCecntrEconsDay>lambdaQuery()
                        .eq(StatCecntrEconsDay::getOrgNo, item.getOrgNo())
                        .eq(StatCecntrEconsDay::getCeCustId, item.getCeCustId())
                        .eq(StatCecntrEconsDay::getCeCntrId, item.getCeCntrId())
                        .eq(StatCecntrEconsDay::getCeResSortNo, item.getCeResSortNo())
                        .eq(StatCecntrEconsDay::getDateStat, item.getDateStat());
                int count = statCecntrEconsDayMapper.selectCount(lambdaQueryWrapper);
                if (count > 0) {
                    statCecntrEconsDayMapper.update(item, lambdaQueryWrapper);
                } else {
                    statCecntrEconsDayMapper.insert(item);
                }
            } else {
                StatCecntrEconsDay target = StatisticsDataUtils.computeAdd96PointEconsValue(item, day);
                target.setEconsValueDay(StatisticsDataUtils.addBigDecimal(item.getEconsValueDay(), day.getEconsValueDay()));
                target.setEconsValueDr1(StatisticsDataUtils.addBigDecimal(item.getEconsValueDr1(), day.getEconsValueDr1()));
                target.setEconsValueDr2(StatisticsDataUtils.addBigDecimal(item.getEconsValueDr2(), day.getEconsValueDr2()));
                target.setEconsValueDr3(StatisticsDataUtils.addBigDecimal(item.getEconsValueDr3(), day.getEconsValueDr3()));
                target.setEconsValueDr4(StatisticsDataUtils.addBigDecimal(item.getEconsValueDr4(), day.getEconsValueDr4()));
                target.setExpenseDay(StatisticsDataUtils.addBigDecimal(item.getExpenseDay(), day.getExpenseDay()));
                target.setExpenseDr1(StatisticsDataUtils.addBigDecimal(item.getExpenseDr1(), day.getExpenseDr1()));
                target.setExpenseDr2(StatisticsDataUtils.addBigDecimal(item.getExpenseDr2(), day.getExpenseDr2()));
                target.setExpenseDr3(StatisticsDataUtils.addBigDecimal(item.getExpenseDr3(), day.getExpenseDr3()));
                target.setExpenseDr4(StatisticsDataUtils.addBigDecimal(item.getExpenseDr4(), day.getExpenseDr4()));
                LambdaQueryWrapper<StatCecntrEconsDay> lambdaQueryWrapper = Wrappers.<StatCecntrEconsDay>lambdaQuery()
                        .eq(StatCecntrEconsDay::getOrgNo, target.getOrgNo())
                        .eq(StatCecntrEconsDay::getCeCustId, target.getCeCustId())
                        .eq(StatCecntrEconsDay::getCeCntrId, target.getCeCntrId())
                        .eq(StatCecntrEconsDay::getCeResSortNo, target.getCeResSortNo())
                        .eq(StatCecntrEconsDay::getDateStat, target.getDateStat());
                int count = statCecntrEconsDayMapper.selectCount(lambdaQueryWrapper);
                if (count > 0) {
                    statCecntrEconsDayMapper.update(target, lambdaQueryWrapper);
                } else {
                    statCecntrEconsDayMapper.insert(target);
                }
            }
        }
        // TODO 月
        startContainerMonthJob(dateDTO.getMonthDateDTO());
        // TODO 年
        startContainerYearJob(dateDTO.getYearDateDTO());
    }

    @Override
    public void startContainerMonthJob(StatisticsMonthDateDTO dateDTO) {
        List<StatCecntrEconsMonth> dataList = statEconsSelectMapper.selectCeContainerMonth(dateDTO.getStart(), dateDTO.getEnd());
        if (dataList.size() == 0) {
            return;
        }
        statEconsInsertMapper.batchInsertOrUpdateStatCecntrEconsMonth(StatisticsDataUtils.initData(dataList));
    }

    @Override
    public void startContainerYearJob(StatisticsYearDateDTO dateDTO) {
        List<StatCecntrEconsYear> dataList = statEconsSelectMapper.selectCeContainerYear(dateDTO.getStart(), dateDTO.getEnd());
        if (dataList.size() == 0) {
            return;
        }
        statEconsInsertMapper.batchInsertOrUpdateStatCecntrEconsYear(StatisticsDataUtils.initData(dataList));

        // TODO 累计
        LambdaQueryWrapper<StatCecntrEconsYear> lambdaQueryWrapper = Wrappers.<StatCecntrEconsYear>lambdaQuery()
                .select(StatCecntrEconsYear::getCeCntrId, StatCecntrEconsYear::getOrgNo,
                        StatCecntrEconsYear::getEconsValueYear, StatCecntrEconsYear::getEconsValueYr1, StatCecntrEconsYear::getEconsValueYr2, StatCecntrEconsYear::getEconsValueYr3, StatCecntrEconsYear::getEconsValueYr4,
                        StatCecntrEconsYear::getExpenseYear, StatCecntrEconsYear::getExpenseYr1, StatCecntrEconsYear::getExpenseYr2, StatCecntrEconsYear::getExpenseYr3, StatCecntrEconsYear::getExpenseYr4);
        List<StatCecntrEconsYear> yearList = statCecntrEconsYearMapper.selectList(lambdaQueryWrapper);
        if (yearList.isEmpty()) {
            return;
        }
        List<StatCeresAccum> accumList = new ArrayList<>();
        Map<Long, List<StatCecntrEconsYear>> collect = yearList.stream().collect(Collectors.groupingBy(StatCecntrEconsYear::getCeCntrId));
        collect.forEach((ceCntrId, list) -> {
            StatCeresAccum accum = new StatCeresAccum();
            accum.setId(ceCntrId);
            accum.setOrgNo(list.get(0).getOrgNo());
            accum.setCeResClass(3);
            accum.setEconsValueAccum(NumberUtils.addBigDecimal(list.stream().map(StatCecntrEconsYear::getEconsValueYear).collect(Collectors.toList())));
            accum.setEconsValueAr1(NumberUtils.addBigDecimal(list.stream().map(StatCecntrEconsYear::getEconsValueYr1).collect(Collectors.toList())));
            accum.setEconsValueAr2(NumberUtils.addBigDecimal(list.stream().map(StatCecntrEconsYear::getEconsValueYr2).collect(Collectors.toList())));
            accum.setEconsValueAr3(NumberUtils.addBigDecimal(list.stream().map(StatCecntrEconsYear::getEconsValueYr3).collect(Collectors.toList())));
            accum.setEconsValueAr4(NumberUtils.addBigDecimal(list.stream().map(StatCecntrEconsYear::getEconsValueYr4).collect(Collectors.toList())));
            accum.setExpenseAccum(NumberUtils.addBigDecimal(list.stream().map(StatCecntrEconsYear::getExpenseYear).collect(Collectors.toList())));
            accum.setExpenseAr1(NumberUtils.addBigDecimal(list.stream().map(StatCecntrEconsYear::getExpenseYr1).collect(Collectors.toList())));
            accum.setExpenseAr2(NumberUtils.addBigDecimal(list.stream().map(StatCecntrEconsYear::getExpenseYr2).collect(Collectors.toList())));
            accum.setExpenseAr3(NumberUtils.addBigDecimal(list.stream().map(StatCecntrEconsYear::getExpenseYr3).collect(Collectors.toList())));
            accum.setExpenseAr4(NumberUtils.addBigDecimal(list.stream().map(StatCecntrEconsYear::getExpenseYr4).collect(Collectors.toList())));
            accumList.add(accum);
        });
        statCeresAccumMapper.batchInsertOrUpdateStatCeresAccum(accumList);
    }

    @Override
    public void startPartDayJob(StatisticsDateDTO dateDTO) {
        StatisticsDayDateDTO dayDateDTO = dateDTO.getDayDateDTO();
        List<StatCepartEconsDay> dataList = statEconsSelectMapper.selectCePartPointDay(dayDateDTO.getDate());
        List<Long> idList = dataList.stream().map(StatCepartEconsDay::getCePartId).collect(Collectors.toList());
        dataList.addAll(statEconsSelectMapper.selectCePartContainerDay(dayDateDTO.getDate()).stream().filter(item -> !idList.contains(item.getCePartId())).collect(Collectors.toList()));
        dataList.addAll(statEconsSelectMapper.selectCePartDeviceDay(dayDateDTO.getDate()).stream().filter(item -> !idList.contains(item.getCePartId())).collect(Collectors.toList()));
        Map<Long, List<StatCepartEconsDay>> result = dataList.stream().collect(Collectors.groupingBy(StatCepartEconsDay::getCePartId));
        dataList.clear();
        result.forEach((cePartId, list) -> {
            StatCepartEconsDay day = StatisticsDataUtils.computeAdd96PointEconsValue(list);
            day.setEconsValueDay(StatisticsDataUtils.computeAddByList(list, StatCepartEconsDay::getEconsValueDay));
            day.setEconsValueDr1(StatisticsDataUtils.computeAddByList(list, StatCepartEconsDay::getEconsValueDr1));
            day.setEconsValueDr2(StatisticsDataUtils.computeAddByList(list, StatCepartEconsDay::getEconsValueDr2));
            day.setEconsValueDr3(StatisticsDataUtils.computeAddByList(list, StatCepartEconsDay::getEconsValueDr3));
            day.setEconsValueDr4(StatisticsDataUtils.computeAddByList(list, StatCepartEconsDay::getEconsValueDr4));
            StatisticsDataUtils.initData(day);
            dataList.add(day);
        });
        if (dataList.size() > 0) {
            // TODO 日
            statEconsInsertMapper.batchInsertOrUpdateStatCepartEconsDay(dataList);
            // TODO 月
            startPartMonthJob(dateDTO.getMonthDateDTO());
            // TODO 年
            startPartYearJob(dateDTO.getYearDateDTO());
        }
    }

    @Override
    public void startPartMonthJob(StatisticsMonthDateDTO dateDTO) {
        List<StatCepartEconsMonth> dataList = statEconsSelectMapper.selectCePartMonth(dateDTO.getStart(), dateDTO.getEnd());
        if (dataList.size() == 0) {
            return;
        }
        StatisticsDataUtils.initData(dataList);
        statEconsInsertMapper.batchInsertOrUpdateStatCepartEconsMonth(dataList);
    }

    @Override
    public void startPartYearJob(StatisticsYearDateDTO dateDTO) {
        List<StatCepartEconsYear> dataList = statEconsSelectMapper.selectCePartYear(dateDTO.getStart(), dateDTO.getEnd());
        if (dataList.size() == 0) {
            return;
        }
        StatisticsDataUtils.initData(dataList);
        statEconsInsertMapper.batchInsertOrUpdateStatCepartEconsYear(dataList);
    }

    @Override
    public void startCustDayJob(StatisticsDateDTO dateDTO) {
        StatisticsDayDateDTO dayDateDTO = dateDTO.getDayDateDTO();
        List<StatCecustEconsDay> dataList = statEconsSelectMapper.selectCeCustPointDay(dayDateDTO.getDate());
        List<Long> idList = dataList.stream().map(StatCecustEconsDay::getCeCustId).collect(Collectors.toList());
        dataList.addAll(statEconsSelectMapper.selectCeCustPartDay(dayDateDTO.getDate()).stream().filter(item -> !idList.contains(item.getCeCustId())).collect(Collectors.toList()));
        dataList.addAll(statEconsSelectMapper.selectCeCustContainerDay(dayDateDTO.getDate()).stream().filter(item -> !idList.contains(item.getCeCustId())).collect(Collectors.toList()));
        dataList.addAll(statEconsSelectMapper.selectCeCustDeviceDay(dayDateDTO.getDate()).stream().filter(item -> !idList.contains(item.getCeCustId())).collect(Collectors.toList()));
        Map<Long, List<StatCecustEconsDay>> result = dataList.stream().collect(Collectors.groupingBy(StatCecustEconsDay::getCeCustId));
        dataList.clear();
        result.forEach((ceCustId, list) -> {
            StatCecustEconsDay day = StatisticsDataUtils.computeAdd96PointEconsValue(list);
            day.setEconsValueDay(StatisticsDataUtils.computeAddByList(list, StatCecustEconsDay::getEconsValueDay));
            day.setEconsValueDr1(StatisticsDataUtils.computeAddByList(list, StatCecustEconsDay::getEconsValueDr1));
            day.setEconsValueDr2(StatisticsDataUtils.computeAddByList(list, StatCecustEconsDay::getEconsValueDr2));
            day.setEconsValueDr3(StatisticsDataUtils.computeAddByList(list, StatCecustEconsDay::getEconsValueDr3));
            day.setEconsValueDr4(StatisticsDataUtils.computeAddByList(list, StatCecustEconsDay::getEconsValueDr4));
            StatisticsDataUtils.initData(day);
            dataList.add(day);
        });
        if (dataList.size() > 0) {
            // TODO 日
            statEconsInsertMapper.batchInsertOrUpdateStatCecustEconsDay(dataList);
            // TODO 月
            startCustMonthJob(dateDTO.getMonthDateDTO());
            // TODO 年
            startCustYearJob(dateDTO.getYearDateDTO());
        }

    }

    @Override
    public void startCustMonthJob(StatisticsMonthDateDTO dateDTO) {
        List<StatCecustEconsMonth> dataList = statEconsSelectMapper.selectCeCustMonth(dateDTO.getStart(), dateDTO.getEnd());
        if (dataList.size() == 0) {
            return;
        }
        StatisticsDataUtils.initData(dataList);
        statEconsInsertMapper.batchInsertOrUpdateStatCecustEconsMonth(dataList);
    }

    @Override
    public void startCustYearJob(StatisticsYearDateDTO dateDTO) {
        List<StatCecustEconsYear> dataList = statEconsSelectMapper.selectCeCustYear(dateDTO.getStart(), dateDTO.getEnd());
        if (dataList.size() == 0) {
            return;
        }
        StatisticsDataUtils.initData(dataList);
        statEconsInsertMapper.batchInsertOrUpdateStatCecustEconsYear(dataList);

        // TODO 累计
//        List<StatCecustEconsDay> dayList = statEconsSelectMapper.selectCeCustAccum();
//        if (dayList.size() == 0) {
//            return;
//        }
//        dayList.forEach(item -> {
//            StatisticsDataUtils.initData(item);
//            item.setDateStat(dateDTO.getDateStat());
//        });
//        statEconsInsertMapper.batchInsertOrUpdateStatCecustEconsDayAccum(dayList);
    }

    @Override
    public void startOrgDayJob(StatisticsDateDTO dateDTO) {
        List<StatOrgEconsDay> dataList = statEconsSelectMapper.selectOrgCustDay(dateDTO.getDayDateDTO().getDate());
        if (dataList.size() == 0) {
            return;
        }
        statEconsInsertMapper.batchInsertOrUpdateStatOrgEconsDay(StatisticsDataUtils.initData(dataList));
        dataList.clear();
        SysOrgQueryResponse orgResponse = remoteSystemService.querySysOrg(new SysOrgQueryRequest());
        if (CollectionUtil.isEmpty(orgResponse.getSysOrgList())) {
            return;
        }
        List<String> orgList = orgResponse.getSysOrgList().stream().map(SysOrg::getOrgNo).collect(Collectors.toList());
        orgList.forEach(orgNo -> {
            StatOrgEconsDay day = statEconsSelectMapper.selectOrgParentDay(orgNo, dateDTO.getDayDateDTO().getDate());
            if (day != null) {
                dataList.add(StatisticsDataUtils.initData(day));
            }
        });
        if (dataList.size() > 0) {
            // TODO 日
            statEconsInsertMapper.batchInsertOrUpdateStatOrgEconsDay(dataList);
            // TODO 月
            startOrgMonthJob(dateDTO.getMonthDateDTO());
            // TODO 年
            startOrgYearJob(dateDTO.getYearDateDTO());
        }

    }

    @Override
    public void startOrgMonthJob(StatisticsMonthDateDTO dateDTO) {
        List<StatOrgEconsMonth> dataList = statEconsSelectMapper.selectOrgMonth(dateDTO.getStart(), dateDTO.getEnd());
        if (dataList.size() == 0) {
            return;
        }
        statEconsInsertMapper.batchInsertOrUpdateStatOrgEconsMonth(StatisticsDataUtils.initData(dataList));
    }

    @Override
    public void startOrgYearJob(StatisticsYearDateDTO dateDTO) {
        List<StatOrgEconsYear> dataList = statEconsSelectMapper.selectOrgYear(dateDTO.getStart(), dateDTO.getEnd());
        if (dataList.size() == 0) {
            return;
        }
        statEconsInsertMapper.batchInsertOrUpdateStatOrgEconsYear(StatisticsDataUtils.initData(dataList));
    }
}
