package com.gaea.iesms.bm.standalone.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Dict;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.standalone.config.GlobalConfig;
import com.gaea.iesms.bm.standalone.mapper.*;
import com.gaea.iesms.bm.standalone.model.dto.AvgMaxMinValueDTO;
import com.gaea.iesms.bm.standalone.model.dto.StatisticsDateDTO;
import com.gaea.iesms.bm.standalone.model.dto.StatisticsMonthDateDTO;
import com.gaea.iesms.bm.standalone.model.dto.StatisticsYearDateDTO;
import com.gaea.iesms.bm.standalone.model.vo.ContainerInfoVo;
import com.gaea.iesms.bm.standalone.service.StatEloadService;
import com.gaea.iesms.bm.standalone.util.StatisticsDataUtils;
import com.gaea.iesms.core.feign.dto.SysOrg;
import com.gaea.iesms.core.feign.dto.SysOrgQueryResponse;
import com.gaea.iesms.core.feign.request.SysOrgQueryRequest;
import com.gaea.iesms.core.feign.request.datacenter.MeasDataInsFreezeCurveGetRangeRequest;
import com.gaea.iesms.core.feign.response.datacenter.MeasDataInsFreezeCurveGetRangeBaseResponse;
import com.gaea.iesms.core.feign.response.datacenter.MeasDataInsFreezeCurveGetRangeListResponse;
import com.gaea.iesms.core.feign.response.datacenter.MeasDataInsFreezeCurveValue;
import com.gaea.iesms.core.feign.service.DataCenterCommonService;
import com.gaea.iesms.core.feign.service.RemoteSystemService;
import com.gaea.iesms.core.model.entity.standalone.*;
import com.gaea.iesms.core.model.entity.standalone.view.ViewPoint;
import com.gaea.iesms.core.model.jsonobject.standalone.StatDevMeterInfoJsonObject;
import com.gaea.utils.JsonUtils;
import com.gaea.utils.NumberUtils;
import com.gaea.utils.ObjectUtils;
import com.gaea.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/11/29
 */
@Service
public class StatEloadServiceImpl implements StatEloadService {

    private static final Logger LOGGER = LoggerFactory.getLogger(StatEloadServiceImpl.class);
    private static final String GEN_WATT_ACPT = "gen_watt_acpt";
    private static final Set<String> ITEM_CODE_SET = CollectionUtil.newHashSet(GEN_WATT_ACPT);

    @Resource
    private StatSelectMapper statSelectMapper;

    @Resource
    private DataCenterCommonService dataCenterCommonService;

    @Resource
    private StatEloadInsertMapper statEloadInsertMapper;

    @Resource
    private StatCepointEloadDayMapper statCepointEloadDayMapper;

    @Resource
    private StatCepointEloadMonthMapper statCepointEloadMonthMapper;

    @Resource
    private StatEloadSelectMapper statEloadSelectMapper;

    @Resource
    private StatCedeviceEloadDayMapper statCedeviceEloadDayMapper;

    @Resource
    private StatCedeviceEloadMonthMapper statCedeviceEloadMonthMapper;

    @Resource
    private StatCecntrEloadDayMapper statCecntrEloadDayMapper;

    @Resource
    private StatCecntrEloadMonthMapper statCecntrEloadMonthMapper;

    @Resource
    private StatCepartEloadDayMapper statCepartEloadDayMapper;

    @Resource
    private StatCepartEloadMonthMapper statCepartEloadMonthMapper;

    @Resource
    private StatCecustEloadDayMapper statCecustEloadDayMapper;

    @Resource
    private StatCecustEloadMonthMapper statCecustEloadMonthMapper;

    @Resource
    private StatOrgEloadDayMapper statOrgEloadDayMapper;

    @Resource
    private StatOrgEloadMonthMapper statOrgEloadMonthMapper;

    @Resource
    private ViewPointMapper viewPointMapper;

    @Resource
    private RemoteSystemService remoteSystemService;

    @Override
    public void startPointDayJob(StatisticsDateDTO dateDTO) {
        List<StatCepointEloadDay> dayList = new ArrayList<>();
        Map<Long, List<ViewPoint>> list = viewPointMapper.selectList(Wrappers.lambdaQuery()).stream().collect(Collectors.groupingBy(ViewPoint::getCePointId));
        list.forEach((cePointId, pointInfoList) -> {

            List<StatDevMeterInfoJsonObject> devMeterInfo = new ArrayList<>();
            List<MeasDataInsFreezeCurveGetRangeRequest> requestList = new ArrayList<>();
            for (ViewPoint pointInfoVo : pointInfoList) {
                MeasDataInsFreezeCurveGetRangeRequest request = new MeasDataInsFreezeCurveGetRangeRequest();
                request.setMeasPointId(pointInfoVo.getMeasPointId());
                request.setMeasItemCodeSet(ITEM_CODE_SET);
                request.setGmtMeasFreezeStart(dateDTO.getDayDateDTO().getStart().getTime());
                request.setGmtMeasFreezeEnd(dateDTO.getDayDateDTO().getEnd().getTime());
                request.setMeasDataSideType(1);
                requestList.add(request);

                devMeterInfo.add(StatDevMeterInfoJsonObject.builder()
                        .devMeterId(pointInfoVo.getDevMeterId())
                        .devMeterNo(pointInfoVo.getDevMeterNo())
                        .devMeterName(pointInfoVo.getDevMeterName())
                        .devMeterCommProto(pointInfoVo.getDevMeterCommProto())
                        .devMeterCommAddr(pointInfoVo.getDevMeterCommAddr())
                        .accessGatewayId(pointInfoVo.getAccessGatewayId())
                        .measPointId(pointInfoVo.getMeasPointId())
                        .selfRate(pointInfoVo.getSelfRate())
                        .ctRate(pointInfoVo.getCtRate())
                        .ptRate(pointInfoVo.getPtRate())
                        .build());
            }

            StatCepointEloadDay day = StatCepointEloadDay.builder()
                    .id(GlobalConfig.SNOWFLAKE.next())
                    .orgNo(pointInfoList.get(0).getOrgNo())
                    .ceCustId(pointInfoList.get(0).getCeCustId())
                    .cePointId(pointInfoList.get(0).getCePointId())
                    .dateStat(dateDTO.getDayDateDTO().getStart())
                    .devMeterInfo(JsonUtils.toJsonStr(devMeterInfo))
                    .gmtCreate(System.currentTimeMillis())
                    .gmtModified(System.currentTimeMillis())
                    .build();
            dayList.add(day);

            R<MeasDataInsFreezeCurveGetRangeListResponse> response = dataCenterCommonService.getRangeMeasDataInsFreezeCurveList(requestList);
            if (response.isSuccess()) {
                Map<Long, List<MeasDataInsFreezeCurveValue>> dataList = response.getData().getDataList().stream().collect(Collectors.toMap(MeasDataInsFreezeCurveGetRangeBaseResponse::getMeasPointId, value -> value.getMeasDataListMap().get(GEN_WATT_ACPT)));
                Dict curve = Dict.create();
                for (ViewPoint pointInfoVo : pointInfoList) {
                    List<MeasDataInsFreezeCurveValue> valueList = dataList.get(pointInfoVo.getMeasPointId());
                    for (MeasDataInsFreezeCurveValue value : valueList) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTimeInMillis(value.getGmtMeasFreeze());
                        int minute;
                        if ((minute = calendar.get(Calendar.MINUTE)) % 15 != 0) {
                            continue;
                        }
                        String keyName = "eloadValue" + StringUtils.fillZero(calendar.get(Calendar.HOUR_OF_DAY) * 4 + minute / 15 + 1, 2);
                        curve.set(keyName, NumberUtils.add(curve.getBigDecimal(keyName), value.getMeasDataValue()));
                    }
                }
                ObjectUtils.copyProperties(curve, day);
                StatisticsDataUtils.computeMaxAndMinValue(day, dateDTO.getDayDateDTO().getStart());
            }
        });
        if (dayList.size() == 0) {
            return;
        }
        statEloadInsertMapper.batchInsertOrUpdateStatCepointEloadDay(dayList);
        // TODO 月
        startPointMonthJob(dateDTO.getMonthDateDTO());
        // TODO 年
        startPointYearJob(dateDTO.getYearDateDTO());
    }

    @Override
    public void startPointMonthJob(StatisticsMonthDateDTO dateDTO) {
        LambdaQueryWrapper<StatCepointEloadDay> lambdaQueryWrapper = Wrappers.<StatCepointEloadDay>lambdaQuery()
                .between(StatCepointEloadDay::getDateStat, dateDTO.getStart(), dateDTO.getEnd());
        List<StatCepointEloadDay> selectList = statCepointEloadDayMapper.selectList(lambdaQueryWrapper);
        Map<Long, List<StatCepointEloadDay>> group = selectList.stream().collect(Collectors.groupingBy(StatCepointEloadDay::getCePointId));
        List<StatCepointEloadMonth> monthList = new ArrayList<>();
        group.forEach((key, val) -> {
            try {
                AvgMaxMinValueDTO valueDTO = StatisticsDataUtils.computeMaxAndMinValue(val);
                StatCepointEloadMonth month = StatCepointEloadMonth.builder()
                        .id(GlobalConfig.SNOWFLAKE.next())
                        .orgNo(val.get(0).getOrgNo())
                        .ceCustId(val.get(0).getCeCustId())
                        .cePointId(val.get(0).getCePointId())
                        .monthStat(dateDTO.getMonthDate())
                        .avgValue(valueDTO.getAvgValue())
                        .maxValue(valueDTO.getMaxValue())
                        .maxValueTime(valueDTO.getMaxValueTime())
                        .minValue(valueDTO.getMinValue())
                        .minValueTime(valueDTO.getMaxValueTime())
                        .gmtCreate(System.currentTimeMillis())
                        .gmtModified(System.currentTimeMillis())
                        .build();
                monthList.add(month);
            } catch (Exception e) {
                LOGGER.error(">>>", e);
            }
        });
        if (monthList.size() == 0) {
            return;
        }
        statEloadInsertMapper.batchInsertOrUpdateStatCepointEloadMonth(monthList);
    }

    @Override
    public void startPointYearJob(StatisticsYearDateDTO dateDTO) {
        LambdaQueryWrapper<StatCepointEloadMonth> lambdaQueryWrapper = Wrappers.<StatCepointEloadMonth>lambdaQuery()
                .between(StatCepointEloadMonth::getMonthStat, dateDTO.getStart(), dateDTO.getEnd());
        List<StatCepointEloadMonth> monthList = statCepointEloadMonthMapper.selectList(lambdaQueryWrapper);
        Map<Long, List<StatCepointEloadMonth>> group = monthList.stream().collect(Collectors.groupingBy(StatCepointEloadMonth::getCePointId));
        List<StatCepointEloadYear> yearList = new ArrayList<>();
        group.forEach((key, val) -> {
            try {
                AvgMaxMinValueDTO valueDTO = StatisticsDataUtils.computeMaxAndMinValue(val);
                StatCepointEloadYear year = StatCepointEloadYear.builder()
                        .id(GlobalConfig.SNOWFLAKE.next())
                        .orgNo(val.get(0).getOrgNo())
                        .ceCustId(val.get(0).getCeCustId())
                        .cePointId(val.get(0).getCePointId())
                        .yearStat(dateDTO.getYearDate())
                        .avgValue(valueDTO.getAvgValue())
                        .maxValue(valueDTO.getMaxValue())
                        .maxValueTime(valueDTO.getMaxValueTime())
                        .minValue(valueDTO.getMinValue())
                        .minValueTime(valueDTO.getMaxValueTime())
                        .gmtCreate(System.currentTimeMillis())
                        .gmtModified(System.currentTimeMillis())
                        .build();
                yearList.add(year);
            } catch (Exception e) {
                LOGGER.error(">>>", e);
            }
        });
        if (yearList.size() == 0) {
            return;
        }
        statEloadInsertMapper.batchInsertOrUpdateStatCepointEloadYear(yearList);
    }

    @Override
    public void startDeviceDayJob(StatisticsDateDTO dateDTO) {
        List<StatCedeviceEloadDay> dayList = statEloadSelectMapper.selectCeDevicePointDay(dateDTO.getDayDateDTO().getDate());
        dayList.forEach(item -> {
            try {
                StatisticsDataUtils.computeMaxAndMinValue(item, item.getDateStat());
                item.setId(GlobalConfig.SNOWFLAKE.next());
                item.setGmtCreate(System.currentTimeMillis());
                item.setGmtModified(System.currentTimeMillis());
            } catch (Exception e) {
                LOGGER.error(">>>", e);
            }
        });
        if (dayList.size() == 0) {
            return;
        }
        statEloadInsertMapper.batchInsertOrUpdateStatCedeviceEloadDay(dayList);
        // TODO 月
        startDeviceMonthJob(dateDTO.getMonthDateDTO());
        // TODO 年
        startDeviceYearJob(dateDTO.getYearDateDTO());
    }

    @Override
    public void startDeviceMonthJob(StatisticsMonthDateDTO dateDTO) {
        LambdaQueryWrapper<StatCedeviceEloadDay> lambdaQueryWrapper = Wrappers.<StatCedeviceEloadDay>lambdaQuery()
                .between(StatCedeviceEloadDay::getDateStat, dateDTO.getStart(), dateDTO.getEnd());
        List<StatCedeviceEloadDay> dayList = statCedeviceEloadDayMapper.selectList(lambdaQueryWrapper);
        Map<Long, List<StatCedeviceEloadDay>> group = dayList.stream().collect(Collectors.groupingBy(StatCedeviceEloadDay::getCeDeviceId));
        List<StatCedeviceEloadMonth> monthList = new ArrayList<>();
        group.forEach((key, val) -> {
            try {
                AvgMaxMinValueDTO valueDTO = StatisticsDataUtils.computeMaxAndMinValue(val);
                StatCedeviceEloadMonth month = StatCedeviceEloadMonth.builder()
                        .id(GlobalConfig.SNOWFLAKE.next())
                        .orgNo(val.get(0).getOrgNo())
                        .ceCustId(val.get(0).getCeCustId())
                        .ceDeviceId(val.get(0).getCeDeviceId())
                        .ceResSortNo(val.get(0).getCeResSortNo())
                        .monthStat(dateDTO.getMonthDate())
                        .avgValue(valueDTO.getAvgValue())
                        .maxValue(valueDTO.getMaxValue())
                        .maxValueTime(valueDTO.getMaxValueTime())
                        .minValue(valueDTO.getMinValue())
                        .minValueTime(valueDTO.getMaxValueTime())
                        .gmtCreate(System.currentTimeMillis())
                        .gmtModified(System.currentTimeMillis())
                        .build();
                monthList.add(month);
            } catch (Exception e) {
                LOGGER.error(">>>", e);
            }
        });
        if (monthList.size() == 0) {
            return;
        }
        statEloadInsertMapper.batchInsertOrUpdateStatCedeviceEloadMonth(monthList);
    }

    @Override
    public void startDeviceYearJob(StatisticsYearDateDTO dateDTO) {
        LambdaQueryWrapper<StatCedeviceEloadMonth> lambdaQueryWrapper = Wrappers.<StatCedeviceEloadMonth>lambdaQuery()
                .between(StatCedeviceEloadMonth::getMonthStat, dateDTO.getStart(), dateDTO.getEnd());
        List<StatCedeviceEloadMonth> monthList = statCedeviceEloadMonthMapper.selectList(lambdaQueryWrapper);
        Map<Long, List<StatCedeviceEloadMonth>> group = monthList.stream().collect(Collectors.groupingBy(StatCedeviceEloadMonth::getCeDeviceId));
        List<StatCedeviceEloadYear> yearList = new ArrayList<>();
        group.forEach((key, val) -> {
            try {
                AvgMaxMinValueDTO valueDTO = StatisticsDataUtils.computeMaxAndMinValue(val);
                StatCedeviceEloadYear year = StatCedeviceEloadYear.builder()
                        .id(GlobalConfig.SNOWFLAKE.next())
                        .orgNo(val.get(0).getOrgNo())
                        .ceCustId(val.get(0).getCeCustId())
                        .ceDeviceId(val.get(0).getCeDeviceId())
                        .ceResSortNo(val.get(0).getCeResSortNo())
                        .yearStat(dateDTO.getYearDate())
                        .avgValue(valueDTO.getAvgValue())
                        .maxValue(valueDTO.getMaxValue())
                        .maxValueTime(valueDTO.getMaxValueTime())
                        .minValue(valueDTO.getMinValue())
                        .minValueTime(valueDTO.getMaxValueTime())
                        .gmtCreate(System.currentTimeMillis())
                        .gmtModified(System.currentTimeMillis())
                        .build();
                yearList.add(year);
            } catch (Exception e) {
                LOGGER.error(">>>", e);
            }
        });
        if (yearList.size() == 0) {
            return;
        }
        statEloadInsertMapper.batchInsertOrUpdateStatCedeviceEloadYear(yearList);
    }

    @Override
    public void startContainerDayJob(StatisticsDateDTO dateDTO) {
        List<StatCecntrEloadDay> dataList = statEloadSelectMapper.selectContainerPointDay(dateDTO.getDayDateDTO().getDate());
        List<Long> idList = dataList.stream().map(StatCecntrEloadDay::getCeCntrId).collect(Collectors.toList());
        List<ContainerInfoVo> containerAll = statSelectMapper.selectContainerAll().stream().filter(item -> !idList.contains(item.getId())).collect(Collectors.toList());
        Map<Long, StatCecntrEloadDay> deviceMap = new HashMap<>();
        for (ContainerInfoVo item : containerAll) {
            if (item.getMeterCount() > 0) {
                StatCecntrEloadDay day = statEloadSelectMapper.selectContainerMeterDay(item.getId(), dateDTO.getDayDateDTO().getDate());
                if (day != null) {
                    dataList.add(day);
                }
            } else {
                StatCecntrEloadDay day = statEloadSelectMapper.selectContainerDeviceDay(item.getId(), dateDTO.getDayDateDTO().getDate());
                if (day != null) {
                    dataList.add(day);
                    deviceMap.put(item.getId(), day);
                }
            }
        }
        if (dataList.size() > 0) {
            dataList.forEach(item -> StatisticsDataUtils.computeMaxAndMinValue(item, dateDTO.getDayDateDTO().getStart()));
            statEloadInsertMapper.batchInsertOrUpdateStatCecntrEloadDay(StatisticsDataUtils.initData(dataList));
        }

        List<StatCecntrEloadDay> dayList = new ArrayList<>();
        dataList = statEloadSelectMapper.selectContainerParentDay(dateDTO.getDayDateDTO().getDate());
        for (StatCecntrEloadDay item : dataList) {
            StatCecntrEloadDay day = deviceMap.get(item.getCeCntrId());
            if (day == null) {
                dayList.add(StatisticsDataUtils.computeMaxAndMinValue(item, dateDTO.getDayDateDTO().getStart()));
            } else {
                StatCecntrEloadDay target = StatisticsDataUtils.computeAdd96PointEloadValue(item, day);
                dayList.add(StatisticsDataUtils.computeMaxAndMinValue(target, dateDTO.getDayDateDTO().getStart()));
            }
        }
        if (dayList.size() > 0) {
            statEloadInsertMapper.batchInsertOrUpdateStatCecntrEloadDay(StatisticsDataUtils.initData(dayList));
        }
        // TODO 月
        startContainerMonthJob(dateDTO.getMonthDateDTO());
        // TODO 年
        startContainerYearJob(dateDTO.getYearDateDTO());
    }

    @Override
    public void startContainerMonthJob(StatisticsMonthDateDTO dateDTO) {
        LambdaQueryWrapper<StatCecntrEloadDay> lambdaQueryWrapper = Wrappers.<StatCecntrEloadDay>lambdaQuery()
                .between(StatCecntrEloadDay::getDateStat, dateDTO.getStart(), dateDTO.getEnd());
        List<StatCecntrEloadDay> selectList = statCecntrEloadDayMapper.selectList(lambdaQueryWrapper);
        Map<Long, List<StatCecntrEloadDay>> group = selectList.stream().collect(Collectors.groupingBy(StatCecntrEloadDay::getCeCntrId));
        List<StatCecntrEloadMonth> dataList = new ArrayList<>();
        group.forEach((key, val) -> {
            try {
                AvgMaxMinValueDTO valueDTO = StatisticsDataUtils.computeMaxAndMinValue(val);
                StatCecntrEloadMonth data = StatCecntrEloadMonth.builder()
                        .id(GlobalConfig.SNOWFLAKE.next())
                        .orgNo(val.get(0).getOrgNo())
                        .ceCustId(val.get(0).getCeCustId())
                        .ceCntrId(val.get(0).getCeCntrId())
                        .ceResSortNo(val.get(0).getCeResSortNo())
                        .monthStat(dateDTO.getMonthDate())
                        .avgValue(valueDTO.getAvgValue())
                        .maxValue(valueDTO.getMaxValue())
                        .maxValueTime(valueDTO.getMaxValueTime())
                        .minValue(valueDTO.getMinValue())
                        .minValueTime(valueDTO.getMaxValueTime())
                        .gmtCreate(System.currentTimeMillis())
                        .gmtModified(System.currentTimeMillis())
                        .build();
                dataList.add(data);
            } catch (Exception e) {
                LOGGER.error(">>>", e);
            }
        });
        if (dataList.size() == 0) {
            return;
        }
        statEloadInsertMapper.batchInsertOrUpdateStatCecntrEloadMonth(dataList);
    }

    @Override
    public void startContainerYearJob(StatisticsYearDateDTO dateDTO) {
        LambdaQueryWrapper<StatCecntrEloadMonth> lambdaQueryWrapper = Wrappers.<StatCecntrEloadMonth>lambdaQuery()
                .between(StatCecntrEloadMonth::getMonthStat, dateDTO.getStart(), dateDTO.getEnd());
        List<StatCecntrEloadMonth> selectList = statCecntrEloadMonthMapper.selectList(lambdaQueryWrapper);
        Map<Long, List<StatCecntrEloadMonth>> group = selectList.stream().collect(Collectors.groupingBy(StatCecntrEloadMonth::getCeCntrId));
        List<StatCecntrEloadYear> dataList = new ArrayList<>();
        group.forEach((key, val) -> {
            try {
                AvgMaxMinValueDTO valueDTO = StatisticsDataUtils.computeMaxAndMinValue(val);
                StatCecntrEloadYear data = StatCecntrEloadYear.builder()
                        .id(GlobalConfig.SNOWFLAKE.next())
                        .orgNo(val.get(0).getOrgNo())
                        .ceCustId(val.get(0).getCeCustId())
                        .ceCntrId(val.get(0).getCeCntrId())
                        .ceResSortNo(val.get(0).getCeResSortNo())
                        .yearStat(dateDTO.getYearDate())
                        .avgValue(valueDTO.getAvgValue())
                        .maxValue(valueDTO.getMaxValue())
                        .maxValueTime(valueDTO.getMaxValueTime())
                        .minValue(valueDTO.getMinValue())
                        .minValueTime(valueDTO.getMaxValueTime())
                        .gmtCreate(System.currentTimeMillis())
                        .gmtModified(System.currentTimeMillis())
                        .build();
                dataList.add(data);
            } catch (Exception e) {
                LOGGER.error(">>>", e);
            }
        });
        if (dataList.size() == 0) {
            return;
        }
        statEloadInsertMapper.batchInsertOrUpdateStatCecntrEloadYear(dataList);
    }

    @Override
    public void startPartDayJob(StatisticsDateDTO dateDTO) {
        List<StatCepartEloadDay> dataList = statEloadSelectMapper.selectPartPointDay(dateDTO.getDayDateDTO().getDate());
        List<Long> idList = dataList.stream().map(StatCepartEloadDay::getCePartId).collect(Collectors.toList());
        dataList.addAll(statEloadSelectMapper.selectPartContainerDay(dateDTO.getDayDateDTO().getDate()).stream().filter(item -> !idList.contains(item.getCePartId())).collect(Collectors.toList()));
        dataList.addAll(statEloadSelectMapper.selectPartDeviceDay(dateDTO.getDayDateDTO().getDate()).stream().filter(item -> !idList.contains(item.getCePartId())).collect(Collectors.toList()));
        Map<Long, List<StatCepartEloadDay>> result = dataList.stream().collect(Collectors.groupingBy(StatCepartEloadDay::getCePartId));
        result.forEach((cePartId, list) -> {
            StatCepartEloadDay day = StatisticsDataUtils.computeAdd96PointEloadValue(list);
            StatisticsDataUtils.computeMaxAndMinValue(day, dateDTO.getDayDateDTO().getStart());
            StatisticsDataUtils.initData(day);
        });
        if (dataList.size() == 0) {
            return;
        }
        statEloadInsertMapper.batchInsertOrUpdateStatCepartEloadDay(dataList);
        // TODO 月
        startPartMonthJob(dateDTO.getMonthDateDTO());
        // TODO 年
        startPartYearJob(dateDTO.getYearDateDTO());
    }

    @Override
    public void startPartMonthJob(StatisticsMonthDateDTO dateDTO) {
        LambdaQueryWrapper<StatCepartEloadDay> lambdaQueryWrapper = Wrappers.<StatCepartEloadDay>lambdaQuery()
                .between(StatCepartEloadDay::getDateStat, dateDTO.getStart(), dateDTO.getEnd());
        List<StatCepartEloadDay> selectList = statCepartEloadDayMapper.selectList(lambdaQueryWrapper);
        Map<Long, List<StatCepartEloadDay>> group = selectList.stream().collect(Collectors.groupingBy(StatCepartEloadDay::getCePartId));
        List<StatCepartEloadMonth> dataList = new ArrayList<>();
        group.forEach((key, val) -> {
            try {
                AvgMaxMinValueDTO valueDTO = StatisticsDataUtils.computeMaxAndMinValue(val);
                StatCepartEloadMonth data = StatCepartEloadMonth.builder()
                        .id(GlobalConfig.SNOWFLAKE.next())
                        .orgNo(val.get(0).getOrgNo())
                        .ceCustId(val.get(0).getCeCustId())
                        .cePartId(val.get(0).getCePartId())
                        .ceResSortNo(val.get(0).getCeResSortNo())
                        .monthStat(dateDTO.getMonthDate())
                        .avgValue(valueDTO.getAvgValue())
                        .maxValue(valueDTO.getMaxValue())
                        .maxValueTime(valueDTO.getMaxValueTime())
                        .minValue(valueDTO.getMinValue())
                        .minValueTime(valueDTO.getMaxValueTime())
                        .gmtCreate(System.currentTimeMillis())
                        .gmtModified(System.currentTimeMillis())
                        .version(1)
                        .build();
                dataList.add(data);
            } catch (Exception e) {
                LOGGER.error(">>>", e);
            }
        });
        if (dataList.size() == 0) {
            return;
        }
        statEloadInsertMapper.batchInsertOrUpdateStatCepartEloadMonth(dataList);
    }

    @Override
    public void startPartYearJob(StatisticsYearDateDTO dateDTO) {
        LambdaQueryWrapper<StatCepartEloadMonth> lambdaQueryWrapper = Wrappers.<StatCepartEloadMonth>lambdaQuery()
                .between(StatCepartEloadMonth::getMonthStat, dateDTO.getStart(), dateDTO.getEnd());
        List<StatCepartEloadMonth> selectList = statCepartEloadMonthMapper.selectList(lambdaQueryWrapper);
        Map<Long, List<StatCepartEloadMonth>> group = selectList.stream().collect(Collectors.groupingBy(StatCepartEloadMonth::getCePartId));
        List<StatCepartEloadYear> dataList = new ArrayList<>();
        group.forEach((key, val) -> {
            try {
                AvgMaxMinValueDTO valueDTO = StatisticsDataUtils.computeMaxAndMinValue(val);
                StatCepartEloadYear data = StatCepartEloadYear.builder()
                        .id(GlobalConfig.SNOWFLAKE.next())
                        .orgNo(val.get(0).getOrgNo())
                        .ceCustId(val.get(0).getCeCustId())
                        .cePartId(val.get(0).getCePartId())
                        .ceResSortNo(val.get(0).getCeResSortNo())
                        .yearStat(dateDTO.getYearDate())
                        .avgValue(valueDTO.getAvgValue())
                        .maxValue(valueDTO.getMaxValue())
                        .maxValueTime(valueDTO.getMaxValueTime())
                        .minValue(valueDTO.getMinValue())
                        .minValueTime(valueDTO.getMaxValueTime())
                        .gmtCreate(System.currentTimeMillis())
                        .gmtModified(System.currentTimeMillis())
                        .version(1)
                        .build();
                dataList.add(data);
            } catch (Exception e) {
                LOGGER.error(">>>", e);
            }
        });
        if (dataList.size() == 0) {
            return;
        }
        statEloadInsertMapper.batchInsertOrUpdateStatCepartEloadYear(dataList);
    }

    @Override
    public void startCustDayJob(StatisticsDateDTO dateDTO) {
        List<StatCecustEloadDay> dataList = statEloadSelectMapper.selectCustPointDay(dateDTO.getDayDateDTO().getDate());
        List<Long> idList = dataList.stream().map(StatCecustEloadDay::getCeCustId).collect(Collectors.toList());
        dataList.addAll(statEloadSelectMapper.selectCustPartDay(dateDTO.getDayDateDTO().getDate()).stream().filter(item -> !idList.contains(item.getCeCustId())).collect(Collectors.toList()));
        dataList.addAll(statEloadSelectMapper.selectCustContainerDay(dateDTO.getDayDateDTO().getDate()).stream().filter(item -> !idList.contains(item.getCeCustId())).collect(Collectors.toList()));
        dataList.addAll(statEloadSelectMapper.selectCustDeviceDay(dateDTO.getDayDateDTO().getDate()).stream().filter(item -> !idList.contains(item.getCeCustId())).collect(Collectors.toList()));
        Map<Long, List<StatCecustEloadDay>> result = dataList.stream().collect(Collectors.groupingBy(StatCecustEloadDay::getCeCustId));
        result.forEach((id, list) -> {
            StatCecustEloadDay day = StatisticsDataUtils.computeAdd96PointEloadValue(list);
            StatisticsDataUtils.computeMaxAndMinValue(day, dateDTO.getDayDateDTO().getStart());
            StatisticsDataUtils.initData(day);
        });
        if (dataList.size() == 0) {
            return;
        }
        statEloadInsertMapper.batchInsertOrUpdateStatCecustEloadDay(dataList);
        // TODO 月
        startCustMonthJob(dateDTO.getMonthDateDTO());
        // TODO 年
        startCustYearJob(dateDTO.getYearDateDTO());
    }

    @Override
    public void startCustMonthJob(StatisticsMonthDateDTO dateDTO) {
        LambdaQueryWrapper<StatCecustEloadDay> lambdaQueryWrapper = Wrappers.<StatCecustEloadDay>lambdaQuery()
                .between(StatCecustEloadDay::getDateStat, dateDTO.getStart(), dateDTO.getEnd());
        List<StatCecustEloadDay> selectList = statCecustEloadDayMapper.selectList(lambdaQueryWrapper);
        Map<Long, List<StatCecustEloadDay>> group = selectList.stream().collect(Collectors.groupingBy(StatCecustEloadDay::getCeCustId));
        List<StatCecustEloadMonth> dataList = new ArrayList<>();
        group.forEach((key, val) -> {
            try {
                AvgMaxMinValueDTO valueDTO = StatisticsDataUtils.computeMaxAndMinValue(val);
                StatCecustEloadMonth data = StatCecustEloadMonth.builder()
                        .id(GlobalConfig.SNOWFLAKE.next())
                        .orgNo(val.get(0).getOrgNo())
                        .ceCustId(val.get(0).getCeCustId())
                        .monthStat(dateDTO.getMonthDate())
                        .avgValue(valueDTO.getAvgValue())
                        .maxValue(valueDTO.getMaxValue())
                        .maxValueTime(valueDTO.getMaxValueTime())
                        .minValue(valueDTO.getMinValue())
                        .minValueTime(valueDTO.getMaxValueTime())
                        .gmtCreate(System.currentTimeMillis())
                        .gmtModified(System.currentTimeMillis())
                        .version(1)
                        .build();
                dataList.add(data);
            } catch (Exception e) {
                LOGGER.error(">>>", e);
            }
        });
        if (dataList.size() == 0) {
            return;
        }
        statEloadInsertMapper.batchInsertOrUpdateStatCecustEloadMonth(dataList);
    }

    @Override
    public void startCustYearJob(StatisticsYearDateDTO dateDTO) {
        LambdaQueryWrapper<StatCecustEloadMonth> lambdaQueryWrapper = Wrappers.<StatCecustEloadMonth>lambdaQuery()
                .between(StatCecustEloadMonth::getMonthStat, dateDTO.getStart(), dateDTO.getEnd());
        List<StatCecustEloadMonth> selectList = statCecustEloadMonthMapper.selectList(lambdaQueryWrapper);
        Map<Long, List<StatCecustEloadMonth>> group = selectList.stream().collect(Collectors.groupingBy(StatCecustEloadMonth::getCeCustId));
        List<StatCecustEloadYear> dataList = new ArrayList<>();
        group.forEach((key, val) -> {
            try {
                AvgMaxMinValueDTO valueDTO = StatisticsDataUtils.computeMaxAndMinValue(val);
                StatCecustEloadYear data = StatCecustEloadYear.builder()
                        .id(GlobalConfig.SNOWFLAKE.next())
                        .orgNo(val.get(0).getOrgNo())
                        .ceCustId(val.get(0).getCeCustId())
                        .yearStat(dateDTO.getYearDate())
                        .avgValue(valueDTO.getAvgValue())
                        .maxValue(valueDTO.getMaxValue())
                        .maxValueTime(valueDTO.getMaxValueTime())
                        .minValue(valueDTO.getMinValue())
                        .minValueTime(valueDTO.getMaxValueTime())
                        .gmtCreate(System.currentTimeMillis())
                        .gmtModified(System.currentTimeMillis())
                        .version(1)
                        .build();
                dataList.add(data);
            } catch (Exception e) {
                LOGGER.error(">>>", e);
            }
        });
        if (dataList.size() == 0) {
            return;
        }
        statEloadInsertMapper.batchInsertOrUpdateStatCecustEloadYear(dataList);
    }

    @Override
    public void startOrgDayJob(StatisticsDateDTO dateDTO) {
        try {
            List<StatOrgEloadDay> dataList = statEloadSelectMapper.selectOrgCustDay(dateDTO.getDayDateDTO().getDate());
            if (dataList.size() == 0) {
                return;
            }
            statEloadInsertMapper.batchInsertOrUpdateStatOrgEloadDay(StatisticsDataUtils.initData(dataList));
            dataList.clear();
            SysOrgQueryResponse orgResponse = remoteSystemService.querySysOrg(new SysOrgQueryRequest());
            if (CollectionUtil.isEmpty(orgResponse.getSysOrgList())) {
                return;
            }
            List<String> orgList = orgResponse.getSysOrgList().stream().map(SysOrg::getOrgNo).collect(Collectors.toList());
            orgList.forEach(orgNo -> {
                StatOrgEloadDay day = statEloadSelectMapper.selectOrgParentDay(orgNo, dateDTO.getDayDateDTO().getDate());
                if (day != null) {
                    StatisticsDataUtils.initData(day);
                    dataList.add(StatisticsDataUtils.computeMaxAndMinValue(day, dateDTO.getDayDateDTO().getStart()));
                }
            });
            if (dataList.size() == 0) {
                return;
            }
            statEloadInsertMapper.batchInsertOrUpdateStatOrgEloadDay(StatisticsDataUtils.initData(dataList));
            // TODO 月
            startOrgMonthJob(dateDTO.getMonthDateDTO());
            // TODO 年
            startOrgYearJob(dateDTO.getYearDateDTO());
        } catch (Exception e) {
            LOGGER.error(">>>", e);
        }
    }

    @Override
    public void startOrgMonthJob(StatisticsMonthDateDTO dateDTO) {
        LambdaQueryWrapper<StatOrgEloadDay> lambdaQueryWrapper = Wrappers.<StatOrgEloadDay>lambdaQuery()
                .between(StatOrgEloadDay::getDateStat, dateDTO.getStart(), dateDTO.getEnd());
        List<StatOrgEloadDay> selectList = statOrgEloadDayMapper.selectList(lambdaQueryWrapper);
        Map<String, List<StatOrgEloadDay>> group = selectList.stream().collect(Collectors.groupingBy(StatOrgEloadDay::getOrgNo));
        List<StatOrgEloadMonth> dataList = new ArrayList<>();
        group.forEach((key, val) -> {
            try {
                AvgMaxMinValueDTO valueDTO = StatisticsDataUtils.computeMaxAndMinValue(val);
                StatOrgEloadMonth data = StatOrgEloadMonth.builder()
                        .id(GlobalConfig.SNOWFLAKE.next())
                        .orgNo(val.get(0).getOrgNo())
                        .monthStat(dateDTO.getMonthDate())
                        .avgValue(valueDTO.getAvgValue())
                        .maxValue(valueDTO.getMaxValue())
                        .maxValueTime(valueDTO.getMaxValueTime())
                        .minValue(valueDTO.getMinValue())
                        .minValueTime(valueDTO.getMaxValueTime())
                        .gmtCreate(System.currentTimeMillis())
                        .gmtModified(System.currentTimeMillis())
                        .version(1)
                        .build();
                dataList.add(data);
            } catch (Exception e) {
                LOGGER.error(">>>", e);
            }
        });
        if (dataList.size() == 0) {
            return;
        }
        statEloadInsertMapper.batchInsertOrUpdateStatOrgEloadMonth(dataList);
    }

    @Override
    public void startOrgYearJob(StatisticsYearDateDTO dateDTO) {
        LambdaQueryWrapper<StatOrgEloadMonth> lambdaQueryWrapper = Wrappers.<StatOrgEloadMonth>lambdaQuery()
                .between(StatOrgEloadMonth::getMonthStat, dateDTO.getStart(), dateDTO.getEnd());
        List<StatOrgEloadMonth> selectList = statOrgEloadMonthMapper.selectList(lambdaQueryWrapper);
        Map<String, List<StatOrgEloadMonth>> group = selectList.stream().collect(Collectors.groupingBy(StatOrgEloadMonth::getOrgNo));
        List<StatOrgEloadYear> dataList = new ArrayList<>();
        group.forEach((key, val) -> {
            try {
                AvgMaxMinValueDTO valueDTO = StatisticsDataUtils.computeMaxAndMinValue(val);
                StatOrgEloadYear data = StatOrgEloadYear.builder()
                        .id(GlobalConfig.SNOWFLAKE.next())
                        .orgNo(val.get(0).getOrgNo())
                        .yearStat(dateDTO.getYearDate())
                        .avgValue(valueDTO.getAvgValue())
                        .maxValue(valueDTO.getMaxValue())
                        .maxValueTime(valueDTO.getMaxValueTime())
                        .minValue(valueDTO.getMinValue())
                        .minValueTime(valueDTO.getMaxValueTime())
                        .gmtCreate(System.currentTimeMillis())
                        .gmtModified(System.currentTimeMillis())
                        .version(1)
                        .build();
                dataList.add(data);
            } catch (Exception e) {
                LOGGER.error(">>>", e);
            }
        });
        if (dataList.size() == 0) {
            return;
        }
        statEloadInsertMapper.batchInsertOrUpdateStatOrgEloadYear(dataList);
    }
}
