package com.gaea.iesms.bm.standalone.service.impl;

import cn.hutool.core.lang.Dict;
import com.gaea.iesms.bm.standalone.mapper.StatStatusMapper;
import com.gaea.iesms.bm.standalone.service.StatStatusService;
import com.gaea.iesms.core.model.entity.standalone.StatOpsStatus;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/12/22
 */
@Service
public class StatStatusServiceImpl implements StatStatusService {

    @Resource
    private StatStatusMapper statStatusMapper;

    @Override
    public void inverterStatus() {
        List<StatOpsStatus> dataList = new ArrayList<>();
        List<Dict> list = statStatusMapper.selectInverterStatus();
        list.forEach(item -> {
            Long inverterId = item.getLong("inverterId");
            String orgNo = item.getStr("orgNo");
            Integer meterCount = item.getInt("meterCount");
            Integer meterGatherAlarmCount = item.getInt("meterGatherAlarmCount");
            Integer inverterAlarmCount = item.getInt("inverterAlarmCount");
            Integer inverterBusAlarmCount = item.getInt("inverterBusAlarmCount");

            StatOpsStatus statOpsStatus = new StatOpsStatus();
            statOpsStatus.setId(inverterId);
            statOpsStatus.setOrgNo(orgNo);
            statOpsStatus.setCeResClass(4);
            statOpsStatus.setGmtCreate(System.currentTimeMillis());
            statOpsStatus.setGmtModified(System.currentTimeMillis());
            statOpsStatus.setVersion(1);

            if (meterCount.equals(meterGatherAlarmCount)) {
                statOpsStatus.setOpsStatus(4);
            } else if (inverterAlarmCount > 0) {
                statOpsStatus.setOpsStatus(3);
            } else if (inverterBusAlarmCount > 0) {
                statOpsStatus.setOpsStatus(2);
            } else {
                statOpsStatus.setOpsStatus(1);
            }
            dataList.add(statOpsStatus);
        });
        if (list.size() == 0) {
            return;
        }
        statStatusMapper.batchInsertOrUpdateStatOpsStatus(dataList);
    }
}
