package com.gaea.iesms.bm.standalone.util;

import com.gaea.utils.ConvertUtils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/4/13
 */
public class JobParamUtils {

    private static Map<String, Object> RELY_MAP = new ConcurrentHashMap<>();

    /**
     * 是否包含 key
     *
     * @param key
     * @return
     */
    public static boolean isContainsKey(String key) {
        return RELY_MAP.containsKey(key);
    }

    /**
     * 添加
     *
     * @param key
     * @param value
     */
    public static void put(String key, Object value) {
        RELY_MAP.put(key, value);
    }

    /**
     * 获取
     *
     * @param key
     * @return
     */
    public static Object get(String key) {
        return RELY_MAP.get(key);
    }

    /**
     * 获取
     *
     * @param key
     * @return
     */
    public static <T> T get(String key, Class<T> type) {
        return ConvertUtils.convert(type, get(key));
    }

    /**
     * 移除
     *
     * @param key
     */
    public static void remove(String key) {
        RELY_MAP.remove(key);
    }

    /**
     * 获取 并 移除
     *
     * @param key
     * @return
     */
    public static Object getAndRemote(String key) {
        Object o = RELY_MAP.get(key);
        RELY_MAP.remove(key);
        return o;
    }

    /**
     * 获取指定类型值 并 移除
     * @param key
     * @param type
     * @param <T>
     * @return
     */
    public static <T> T getAndRemote(String key, Class<T> type) {
        Object value = getAndRemote(key);
        return ConvertUtils.convert(type, value);
    }
}
