package com.gaea.iesms.bm.standalone.util;

import cn.hutool.core.date.DateUtil;
import com.gaea.iesms.bm.standalone.model.dto.StatisticsDateDTO;
import com.gaea.iesms.bm.standalone.model.dto.StatisticsDayDateDTO;
import com.gaea.iesms.bm.standalone.model.dto.StatisticsMonthDateDTO;
import com.gaea.iesms.bm.standalone.model.dto.StatisticsYearDateDTO;
import com.gaea.utils.DateUtils;

import java.util.Date;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/4/12
 */
public class StatisticsDateUtils {

    /**
     * 获取统计日期
     *
     * @param date 格式（yyyy-MM-dd）
     * @return StatisticsDateDTO
     */
    public static StatisticsDateDTO date(String date) {
        Date start;
        Date end;
        try {
            start = DateUtil.parseDate(date);
        } catch (Exception e) {
            try {
                start = DateUtil.parseDate(DateUtil.formatDate(new Date()));
            } catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
        end = DateUtils.offsetDay(start, 1);
        StatisticsDayDateDTO dayDateDTO = new StatisticsDayDateDTO(DateUtil.formatDate(start), start, end);

        StatisticsMonthDateDTO monthDateDTO = new StatisticsMonthDateDTO();
        monthDateDTO.setDateStat(dayDateDTO.getStart());
        monthDateDTO.setMonthDate(Integer.valueOf(DateUtil.format(start, "yyyyMM")));
        monthDateDTO.setStart(DateUtils.beginOfMonth(start));
        monthDateDTO.setEnd(DateUtils.endOfMonth(start));
        monthDateDTO.setDayCountOfMonth(DateUtil.dayOfMonth(monthDateDTO.getEnd()));

        StatisticsYearDateDTO yearDateDTO = new StatisticsYearDateDTO();
        yearDateDTO.setDateStat(dayDateDTO.getStart());
        yearDateDTO.setYearDate(Integer.valueOf(DateUtil.format(start, "yyyy")));
        yearDateDTO.setStart(Integer.valueOf(yearDateDTO.getYearDate() + "01"));
        yearDateDTO.setEnd(Integer.valueOf(yearDateDTO.getYearDate() + "12"));
        yearDateDTO.setMonthCountOfYear(12);
        return new StatisticsDateDTO(dayDateDTO, monthDateDTO, yearDateDTO);
    }
}
