package com.gaea.iesms.bm.statistic;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/11/22
 */
@EnableDiscoveryClient
@EnableFeignClients(basePackages = "com.gaea.iesms.core.feign.**")
@SpringBootApplication(scanBasePackages = {"com.gaea.iesms.bm.statistic.**", "com.gaea.mybatis.plus.**", "com.gaea.spring.cloud.starter.**"})
public class StatisticStarter {

    public static void main(final String... args) {
        try {
            SpringApplication.run(StatisticStarter.class, args);
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
}
