package com.gaea.iesms.bm.statistic.model.request.cestat;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * 统计参数
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2023/03/10
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
public class CeStatRequest implements Serializable {

    /**
     * 日期类型；1-日；2-月；3-年
     */
    private String dateType;

    /**
     * 日月年-日期（日：yyyy-MM-dd；月：yyyyMM；年：yyyy）
     */
    private String dateStat;

    /**
     * 单位编号
     */
    private String orgNo;

    /**
     * 单位及用能资源标识
     */
    private String ceStatId;

    /**
     * 单位及用能资源类型（单位-org；用能客户-ceCust；用能区域-cePart；用能容器-ceCntr；用能设备-ceDevice；用能点-cePoint）
     */
    private String ceStatType;
}
