package com.gaea.iesms.bm.iot.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MybatisEnumTypeHandler;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.gaea.iesms.core.model.handler.IesmsEntityMetaObjectHandler;
import com.gaea.utils.StringUtils;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import javax.annotation.Resource;
import javax.sql.DataSource;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2022/5/10
 */
@Configuration
@Order(Ordered.HIGHEST_PRECEDENCE + 2)
@SuppressWarnings("all")
@MapperScan(basePackages = {"com.gaea.iesms.bm.iot.mapper.**"}, sqlSessionTemplateRef = "iesmsSqlSessionTemplate")
public class IesmsMybatisPlusConfig {

    @Value("${mysql.table-prefix:}")
    private String tablePrefix;

    @Resource
    private TablePrefixInterceptorConfig tablePrefixInterceptor;

    @Bean(name = "iesmsSqlSessionFactory")
    @Qualifier("iesmsSqlSessionFactory")
    @Primary
    public SqlSessionFactory iesmsSqlSessionFactory(@Qualifier("iesmsDataSource") DataSource iesmsDataSource) throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        // 配置数据源
        bean.setDataSource(iesmsDataSource);
        // MybatisPlus 配置项
        MybatisConfiguration configuration = new MybatisConfiguration();
        // >> 枚举类转换处理
        configuration.setDefaultEnumTypeHandler(MybatisEnumTypeHandler.class);
        // >> MybatisPlus 全局配置
        GlobalConfig getGlobalConfig = GlobalConfigUtils.getGlobalConfig(configuration);
        // >>>> 是否控制台 print mybatis-plus 的 LOGO
        getGlobalConfig.setBanner(false);
        // >>>> 自动填充处理
        getGlobalConfig.setMetaObjectHandler(new IesmsEntityMetaObjectHandler());

        GlobalConfigUtils.setGlobalConfig(configuration, getGlobalConfig);
        bean.setConfiguration(configuration);
        // 插件
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        // >> 乐观锁插件
        interceptor.addInnerInterceptor(new OptimisticLockerInnerInterceptor());
        // >> 分页插件
        interceptor.addInnerInterceptor(new PaginationInnerInterceptor(DbType.MYSQL));
        // >> 防止全表更新与删除插件
        interceptor.addInnerInterceptor(new BlockAttackInnerInterceptor());

        Interceptor[] plugins;
        if (StringUtils.isNotBlank(tablePrefix)) {
            plugins = new Interceptor[]{ interceptor, tablePrefixInterceptor };
        } else {
            plugins = new Interceptor[]{ interceptor };
        }

        bean.setPlugins(plugins);
        // mybaits-plus多数据源情况下，需要把*Mapper.xml路径写上
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:com/gaea/iesms/bm/iot/mapper/*Mapper.xml"));
        return bean.getObject();
    }

    @Bean(name = "iesmsSqlSessionTemplate")
    @Qualifier("iesmsSqlSessionTemplate")
    @Primary
    public SqlSessionTemplate iesmsSqlSessionTemplate(@Qualifier("iesmsSqlSessionFactory") SqlSessionFactory iesmsSqlSessionFactory) {
        return new SqlSessionTemplate(iesmsSqlSessionFactory);
    }
}
