package com.gaea.iesms.bm.iot.config;

import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.*;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.Properties;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2024/5/21
 */
@Component
@Intercepts({
        @Signature(type = StatementHandler.class, method = "prepare", args = {Connection.class, Integer.class})
})
public class TablePrefixInterceptorConfig implements Interceptor {

    @Value("${mysql.table-prefix:}")
    private String tablePrefix;

    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler) invocation.getTarget();
        String originalSql = statementHandler.getBoundSql().getSql();
        // 替换所有表名（假设表名不包含空格和特殊字符）
        String modifiedSql;
        if (originalSql.toLowerCase().contains("on duplicate key update")) {
            modifiedSql = originalSql.replaceAll("(?i)(from|insert into|join)\\s+([\\w]+)", "$1 " + tablePrefix + "$2");
        } else {
            modifiedSql = originalSql.replaceAll("(?i)(from|update|insert into|join)\\s+([\\w]+)", "$1 " + tablePrefix + "$2");
        }
        Field field = BoundSql.class.getDeclaredField("sql");
        field.setAccessible(true);
        field.set(statementHandler.getBoundSql(), modifiedSql);
        return invocation.proceed();
    }

    @Override
    public Object plugin(Object target) {
        return Plugin.wrap(target, this);
    }

    @Override
    public void setProperties(Properties properties) {
        this.tablePrefix = properties.getProperty("tablePrefix", "");
    }

}
