package com.gaea.iesms.bm.iot.controller;

import cn.hutool.core.date.DateUtil;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.iot.model.request.CommunityConduitPageRequest;
import com.gaea.iesms.bm.iot.model.response.CommunityConduitMeterInfoVo;
import com.gaea.iesms.bm.iot.model.response.CommunityConduitPageScreenVo;
import com.gaea.iesms.bm.iot.model.response.CommunityConduitPageVo;
import com.gaea.iesms.bm.iot.service.CommunityConduitService;
import com.gaea.utils.ExportUtil;
import com.gaea.utils.request.ExportRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.assertj.core.util.Lists;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * 通讯工况
 */
@Api(tags = "通讯工况")
@RestController
@RequestMapping("/communityConduit")
public class CommunityConduitController {

    @Resource
    private CommunityConduitService communityConduitService;

    /**
     *
     * @param ceCustId
     * @param type 1-终端 2-量测设备 3-逆变器 4-PCS的投运数量
     * @return
     */
    @GetMapping("/termMeasCommunityConduit")
    @ApiOperation(value="终端")
    public R termMeasCommunityConduit(String ceCustId,String type,String orgNo){
        return R.ok(communityConduitService.termMeasCommunityConduit(ceCustId,type));
    }

    @ApiOperation(value = "分页查询通讯工况列表-表计大屏")
    @GetMapping("/selectCommunityConduitPageScreenMeas")
    public R<CommunityConduitPageScreenVo> selectCommunityConduitPageScreenMeas(CommunityConduitPageRequest request) {
        return R.ok(communityConduitService.selectCommunityConduitPageScreenMeas(request));
    }

    @ApiOperation(value = "分页查询通讯工况列表")
    @GetMapping("/selectCommunityConduitPage")
    public R<CommunityConduitPageVo> selectCommunityConduitPage(CommunityConduitPageRequest request) {
        return R.ok(communityConduitService.selectCommunityConduitPage(request));
    }

    @ApiOperation(value = "查询挂表计的终端数量、在线离线数量、在线率信息")
    @GetMapping("/getCommunityConduitTermInfo")
    public R getCommunityConduitTermInfo(CommunityConduitPageRequest request) {
        return R.ok(communityConduitService.getCommunityConduitTermInfo(request));
    }

    @ApiOperation(value = "获取表计在线离线信息")
    @GetMapping("/getCommunityConduitMeterInfo")
    public R<List<CommunityConduitMeterInfoVo>> getCommunityConduitMeterInfo(@RequestParam("devMeterIdList") List<String> devMeterIdList) {
        return R.ok(communityConduitService.getCommunityConduitMeterInfo(devMeterIdList));
    }

    /**
     * 导出excel
     */
    @ApiOperation(value = "Excel导出")
    @GetMapping("/export")
    public void export(CommunityConduitPageRequest request) {
        request.setPageNumber(-1);
        request.setPageSize(-1);
        CommunityConduitPageVo iPage = communityConduitService.selectCommunityConduitPage(request);
        List<String> headers = Lists.newArrayList();
        headers.add("devTermNo-终端编号");
        headers.add("devTermName-终端名称");
        headers.add("termStatus-状态");
        headers.add("devTermCommAddr-终端地址");
        headers.add("mfrName-生产厂家");
        headers.add("modelCode-终端型号");
        headers.add("lastCommunityTime-最后通讯时间");
        ExportRequest build = ExportRequest.builder()
                .headers(headers)
                .list(iPage.getList())
                .filename("通讯工况列表" + DateUtil.format(new Date(), "yyyy年MM月dd日"))
                .build();
        ExportUtil.export(build);
    }
}
