package com.gaea.iesms.bm.iot.controller;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.gaea.base.core.R;
import com.gaea.base.enums.HandleCodeEnum;
import com.gaea.iesms.bm.iot.model.request.AssocGmDevMeterRequest;
import com.gaea.iesms.bm.iot.model.request.GmDevMeterPageRequest;
import com.gaea.iesms.bm.iot.model.request.GmDevMeterRequest;
import com.gaea.iesms.bm.iot.model.response.GmDevMeterPageVo;
import com.gaea.iesms.bm.iot.model.response.MeterManagement;
import com.gaea.iesms.bm.iot.service.GmDevMeterService;
import com.gaea.iesms.core.feign.dto.SysCodeSortDTO;
import com.gaea.iesms.core.feign.request.SysCodeSortQueryRequest;
import com.gaea.iesms.core.feign.request.datacenter.EditMeterRequest;
import com.gaea.iesms.core.feign.service.DataCenterCommonService;
import com.gaea.iesms.core.feign.service.RemoteSystemService;
import com.gaea.iesms.core.model.entity.iot.GmDevMeter;
import com.gaea.spring.cloud.starter.util.AuthUtils;
import com.gaea.utils.ExportUtil;
import com.gaea.utils.request.ExportRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author Administrator
 * @version 1.0
 * @description: 量测表计设备
 * @date 2023/3/27 10:07
 */
@Api(tags = "量测表计设备管理")
@RestController
@RequestMapping("/gmDevMeter")
public class GmDevMeterController {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Resource
    private GmDevMeterService gmDevMeterService;

    @Resource
    RemoteSystemService remoteSystemService;

    @Resource
    DataCenterCommonService dataCenterCommonService;

    /**
     * 增加量测表计设备
     */
    @PostMapping("/addGmDevMeter")
    @ApiOperation(value = "增加量测表计设备")
    public R addGmDevMeter(@RequestBody GmDevMeterRequest request) {
        String orgNo = AuthUtils.getOrgNo();
        request.setOrgNo(orgNo);
        GmDevMeter gmDevMeter = new GmDevMeter();
        BeanUtils.copyProperties(request, gmDevMeter);

//        QueryWrapper<GmDevMeter> queryWrapper = new QueryWrapper<GmDevMeter>()
//                .eq(StrUtil.isNotBlank(orgNo), "org_no", orgNo)
//                .eq(StrUtil.isNotBlank(request.getDevMeterCommAddr()), "dev_meter_comm_addr", request.getDevMeterCommAddr());
//        int devMeterCommAddrCount = gmDevMeterService.count(queryWrapper);
//        if (devMeterCommAddrCount > 0) {
//            return R.failure().msg("表计地址已重复");
//        }

        QueryWrapper<GmDevMeter> queryWrapper = new QueryWrapper<GmDevMeter>()
                .like(StrUtil.isNotBlank(orgNo), "org_no", orgNo)
                .eq(StrUtil.isNotBlank(request.getDevMeterNo()), "dev_meter_no", request.getDevMeterNo());
        int devMeterNoCount = gmDevMeterService.count(queryWrapper);
        if (devMeterNoCount > 0) {
            return R.failure().msg("量测设备编号已重复");
        }

        //表计型号
        String modelCode = gmDevMeter.getModelCode();

        //code表获取采集终端通讯规约等信息接口
        SysCodeSortQueryRequest sysCodeSortQueryRequest = new SysCodeSortQueryRequest();
        sysCodeSortQueryRequest.setCodeSortNo("EMS_DEV_METER_MODEL_CODE");
        sysCodeSortQueryRequest.setProjectCode("EMS_CODE");
        R<Map<String, SysCodeSortDTO>> mapR = remoteSystemService.queryCodeSort(sysCodeSortQueryRequest);
        if (mapR.isSuccess()) {
            gmDevMeter.setDevMeterCommMode(ObjectUtil.isEmpty(mapR.getData().get(modelCode))
                    || StrUtil.isEmpty(mapR.getData().get(modelCode).getCodeContent1()) ? null : mapR.getData().get(modelCode).getCodeContent1());
            gmDevMeter.setDevMeterCommProto(ObjectUtil.isEmpty(mapR.getData().get(modelCode))
                    || StrUtil.isEmpty(mapR.getData().get(modelCode).getCodeContent2()) ? null : mapR.getData().get(modelCode).getCodeContent2());
//            gmDevMeter.setDevMeterType(ObjectUtil.isEmpty(mapR.getData().get(modelCode))
//                    || StrUtil.isEmpty(mapR.getData().get(modelCode).getCodeContent3()) ? null : Integer.getInteger(mapR.getData().get(modelCode).getCodeContent3()));
        }
        gmDevMeter.setDevMeterStatus(1);
        gmDevMeter.setDevMeterType(request.getDevMeterType());
        gmDevMeter.setDevMeterCommAddr(request.getDevMeterCommAddr());
        gmDevMeter.setDevMeterNo(request.getDevMeterNo());
        gmDevMeter.setMeasCommParam("{}");
        gmDevMeter.setDevMeterRunParam(ObjectUtil.isNotEmpty(request.getDevMeterRunParam()) ? JSONUtil.parseObj(request.getDevMeterRunParam()) : null);
        gmDevMeter.setAccessGatewayId(0L);
        gmDevMeter.setMeasPointId(0L);
        gmDevMeter.setCreator(AuthUtils.getUserNo());
        gmDevMeter.setGmtCreate(DateUtil.date().getTime());
        gmDevMeter.setIsValid(true);

        boolean save = gmDevMeterService.save(gmDevMeter);
        if (save) {
            return R.enums(HandleCodeEnum.INSERT_SUCCESS);
        }
        return R.enums(HandleCodeEnum.INSERT_ERROR);
    }

    /**
     * 根据量测表计设备id批量删除量测表计设备信息
     */
    @ApiParam(name = "ids", value = "采集终端设备id集合", required = true)
    @RequestMapping(value = "/deleteGmDevMeterById", method = {RequestMethod.POST, RequestMethod.DELETE})
    @ApiOperation(value = "根据量测表计设备id批量删除量测表计设备信息")
    public R deleteGmDevMeterById(@RequestBody Map<String, Object> params) {
        List<String> ids = (List<String>) params.get("ids");
        boolean delete = gmDevMeterService.removeByIds(ids);
        if (delete) {
            return R.enums(HandleCodeEnum.DELETE_SUCCESS);
        } else {
            return R.enums(HandleCodeEnum.DELETE_ERROR);
        }
    }

    /**
     * 修改量测表计设备信息
     */
    @RequestMapping(value = "/updateGmDevMeterById", method = {RequestMethod.POST, RequestMethod.PUT})
    @ApiOperation(value = "修改量测表计设备信息")
    public R updateGmDevMeterById(@RequestBody GmDevMeterRequest request) {
        String orgNo = AuthUtils.getOrgNo();
        GmDevMeter gmDevMeter = gmDevMeterService.getById(request.getId());
        if (gmDevMeter == null) {
            return R.enums(HandleCodeEnum.SELECT_ERROR);
        }
        //BeanUtils.copyProperties(request, gmDevMeter);
        gmDevMeter.setDevMeterNo(request.getDevMeterNo());
        gmDevMeter.setDevMeterType(request.getDevMeterType());
        gmDevMeter.setDevMeterName(request.getDevMeterName());
        gmDevMeter.setDevMeterCommAddr(request.getDevMeterCommAddr());
        gmDevMeter.setDevMeterRunParam(request.getDevMeterRunParam());
        gmDevMeter.setGotorunner(request.getGotorunner());
        gmDevMeter.setHardwareVersion(request.getHardwareVersion());
        gmDevMeter.setMfrCode(request.getMfrCode());
        gmDevMeter.setModelCode(request.getModelCode());
        gmDevMeter.setProdDate(request.getProdDate());
        gmDevMeter.setCtRate(request.getCtRate());
        gmDevMeter.setPtRate(request.getPtRate());
        gmDevMeter.setSelfRate(request.getSelfRate());
        gmDevMeter.setSoftwareVersion(request.getSoftwareVersion());

//        QueryWrapper<GmDevMeter> queryWrapper = new QueryWrapper<GmDevMeter>()
//                .eq(StrUtil.isNotBlank(orgNo), "org_no", orgNo)
//                .eq(StrUtil.isNotBlank(request.getDevMeterCommAddr()), "dev_meter_comm_addr", request.getDevMeterCommAddr());
//        if (!StrUtil.equals(request.getDevMeterCommAddr(), gmDevMeter.getDevMeterCommAddr())) {
//            int devMeterCommAddrCount = gmDevMeterService.count(queryWrapper);
//            if (devMeterCommAddrCount > 0) {
//                return R.failure().msg("表计地址已重复");
//            }
//        }

        QueryWrapper<GmDevMeter> queryWrapper = new QueryWrapper<GmDevMeter>()
                .like(StrUtil.isNotBlank(orgNo), "org_no", orgNo)
                .eq(StrUtil.isNotBlank(request.getDevMeterNo()), "dev_meter_no", request.getDevMeterNo());
        if (!StrUtil.equals(request.getDevMeterNo(), gmDevMeter.getDevMeterNo())) {
            int devMeterNoCount = gmDevMeterService.count(queryWrapper);
            if (devMeterNoCount > 0) {
                return R.failure().msg("量测设备编号已重复");
            }
        }

        gmDevMeter.setModifier(AuthUtils.getUserNo());
        gmDevMeter.setGmtModified(DateUtil.date().getTime());

        //已经装接的需要同步到数据中心侧
        logger.info("gmDevMeter.getAccessGatewayId()" + gmDevMeter.getAccessGatewayId());
        if (gmDevMeter.getAccessGatewayId() != null && gmDevMeter.getAccessGatewayId() != 0L) {
            EditMeterRequest editMeterRequest = new EditMeterRequest();
            editMeterRequest.setOrgNo(orgNo);
            editMeterRequest.setMeasCommMode(gmDevMeter.getDevMeterCommMode());
            editMeterRequest.setAccessGatewayId(gmDevMeter.getAccessGatewayId());
            editMeterRequest.setMeasCommProto(gmDevMeter.getDevMeterCommProto());
            editMeterRequest.setMeasSn(gmDevMeter.getMeasSn());
            editMeterRequest.setMeasCommAddr(StrUtil.isBlank(request.getDevMeterCommAddr()) ? request.getDevMeterNo() : gmDevMeter.getDevMeterCommAddr());
            editMeterRequest.setRunMeasPointId(gmDevMeter.getMeasPointId());
            logger.info("修改量测表计设备信息-数据中心侧参数" + editMeterRequest);
            R<?> r = dataCenterCommonService.editMeter(editMeterRequest);
            logger.info("修改量测表计设备信息-数据中心侧返回" + r);
            if (r.getCode() != 200) {
                return R.failure().msg(r.getMsg());
            }
        }
        boolean update = gmDevMeterService.updateById(gmDevMeter);
        if (update) {
            return R.enums(HandleCodeEnum.MODIFY_SUCCESS);
        }
        return R.enums(HandleCodeEnum.MODIFY_ERROR);
    }

    /**
     * 分页查询量测表计设备列表
     */
    @ApiOperation(value = "分页查询量测表计设备列表")
    @GetMapping("/selectGmDevMeterPage")
    public R<GmDevMeterPageVo> selectGmDevMeterPage(GmDevMeterPageRequest request) {
        return R.ok(gmDevMeterService.selectGmDevMeterPage(request));
    }

    /**
     * 查询关联表计列表
     */
    @ApiOperation(value = "查询关联表计列表")
    @GetMapping("/getAssocGmDevMeterList")
    public R<GmDevMeterPageVo> getAssocGmDevMeterList(AssocGmDevMeterRequest request) {
        return R.ok(gmDevMeterService.getAssocGmDevMeterList(request));
    }

    /**
     * 根据量测点查询工况采集时间
     */
    @ApiOperation(value = "根据量测点查询工况采集时间")
    @GetMapping("/getGmtMessageUp")
    public R getGmtMessageUp(String measPointId) {
        return R.ok(gmDevMeterService.getGmtMessageUp(measPointId));
    }

    /**
     * 根据表计id列表查询表计列表
     */
    @ApiOperation(value = "根据表计id列表查询表计列表")
    @PostMapping("/getDevMeterIdList")
    public R<List<GmDevMeter>> getDevMeterIdList(@RequestBody(required = false) List<String> devMeterIdList) {
        // 处理 devMeterIdList 为 null 的情况，转换为空列表
        if (CollectionUtil.isEmpty(devMeterIdList)) {
            return R.failure(Lists.newArrayList());
        }
        String orgNo = AuthUtils.getOrgNo();
        QueryWrapper<GmDevMeter> queryWrapper = new QueryWrapper<GmDevMeter>()
                .likeRight(StrUtil.isNotBlank(orgNo), "org_no", orgNo)
                .in(CollectionUtil.isNotEmpty(devMeterIdList), "id", devMeterIdList);
        return R.ok(gmDevMeterService.list(queryWrapper));
    }

    @ApiOperation(value = "根据量测点列表查询表计列表")
    @GetMapping("/getDevMeterIdListByMeasPointIdList")
    public R<List<GmDevMeter>> getDevMeterIdListByMeasPointIdList(@RequestParam(value = "measPointIdList", required = false) List<String> measPointIdList) {
        LambdaQueryWrapper<GmDevMeter> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(CollectionUtil.isNotEmpty(measPointIdList), GmDevMeter::getMeasPointId, measPointIdList);
        return R.ok(gmDevMeterService.list(queryWrapper));
    }

    /**
     * 导出excel
     */
    @ApiOperation(value = "Excel导出")
    @GetMapping("/export")
    public void export(GmDevMeterPageRequest request) {
        GmDevMeterPageVo iPage = gmDevMeterService.selectGmDevMeterPage(request);
        List<String> headers = Lists.newArrayList();
        headers.add("devMeterNo-量测设备编号");
        headers.add("devMeterName-量测设备名称");
        headers.add("devMeterStatus-量测设备状态");
        headers.add("devMeterTypeName-量测设备类型");
        headers.add("ceCustName-用能客户名称");
        ExportRequest build = ExportRequest.builder()
                .headers(headers)
                .list(iPage.getList())
                .filename("表计管理列表" + DateUtil.format(new Date(), "yyyy年MM月dd日"))
                .build();
        ExportUtil.export(build);
    }

    /**
     * 批量导入
     */
    @ApiOperation(value = "批量导入")
    @PostMapping("/importTemplate")
    public R importTemplate(@RequestParam("file") MultipartFile file) {
        // 导入参数设置
        ImportParams params = new ImportParams();
        // 设置标题占用行数
        params.setTitleRows(2);
        // 设置表头占用行数
        params.setHeadRows(2);
        // 表计档案管理模板
        List<MeterManagement> elecCabinetTemplate;
        try {
            elecCabinetTemplate = ExcelImportUtil.importExcel(file.getInputStream(), MeterManagement.class, params);
        } catch (Exception e) {
            return R.failure().msg("找不到导入模板文件，错误原因是：" + e);
        }
        List<MeterManagement> resList = elecCabinetTemplate.stream()
                .filter(e -> StrUtil.isNotBlank(e.getModelCode())).collect(Collectors.toList());
        List<GmDevMeter> list = Lists.newArrayList();
        for (MeterManagement res : resList) {
            if (StrUtil.isBlank(res.getDevMeterType())) {
                return R.failure().msg("量测设备类型不能为空");
            }
            if (StrUtil.isBlank(res.getDevMeterNo())) {
                return R.failure().msg("量测设备编号不能为空");
            }
            if (StrUtil.isBlank(res.getDevMeterName())) {
                return R.failure().msg("量测设备名称不能为空");
            }
            if (StrUtil.isBlank(res.getMfrCode())) {
                return R.failure().msg("生产厂家不能为空");
            }
            if (StrUtil.isBlank(res.getModelCode())) {
                return R.failure().msg("设备型号不能为空");
            }

            String devMeterName = res.getDevMeterName();
            String devMeterCommAddr = res.getDevMeterCommAddr();
            String mfrCode = res.getMfrCode();
            String modelCode = res.getModelCode();
            String selfRate = res.getSelfRate();
            BigDecimal bd = StrUtil.isNotEmpty(selfRate) ? new BigDecimal(selfRate) : null;
            String ctRate = res.getCtRate();
            BigDecimal ct = StrUtil.isNotEmpty(ctRate) ? new BigDecimal(ctRate) : null;
            String ptRate = res.getPtRate();
            BigDecimal pt = StrUtil.isNotEmpty(ptRate) ? new BigDecimal(ptRate) : null;
            String prodDate = res.getProdDate();
            String hardwareVersion = res.getHardwareVersion();
            String softwareVersion = res.getSoftwareVersion();

//            QueryWrapper<GmDevMeter> queryWrapper = new QueryWrapper<GmDevMeter>()
//                    .eq("dev_meter_comm_addr", devMeterCommAddr);
//            int devMeterCommAddrCount = gmDevMeterService.count(queryWrapper);
//            if (devMeterCommAddrCount > 0) {
//                return R.failure().msg("表计地址已重复");
//            }
            String orgNo = AuthUtils.getOrgNo();

            QueryWrapper<GmDevMeter> queryWrapper = new QueryWrapper<GmDevMeter>()
                    .like(StrUtil.isNotBlank(orgNo), "org_no", orgNo)
                    .eq(StrUtil.isNotBlank(res.getDevMeterNo()), "dev_meter_no", res.getDevMeterNo());
            int devMeterNoCount = gmDevMeterService.count(queryWrapper);
            if (devMeterNoCount > 0) {
                return R.failure().msg("量测设备编号已重复");
            }

            //code表获取采集终端通讯规约等信息接口
            SysCodeSortQueryRequest sysCodeSortQueryRequest = new SysCodeSortQueryRequest();
            sysCodeSortQueryRequest.setCodeSortNo("EMS_DEV_METER_MODEL_CODE");
            sysCodeSortQueryRequest.setProjectCode("EMS_CODE");
            R<Map<String, SysCodeSortDTO>> mapR = remoteSystemService.queryCodeSort(sysCodeSortQueryRequest);

            GmDevMeter meterDo = new GmDevMeter();
            meterDo.setOrgNo(orgNo);
            if ("".equals(mfrCode)) {
                meterDo.setMfrCode("");
            } else {
                meterDo.setMfrCode(mfrCode);
            }
            if ("".equals(modelCode)) {
                meterDo.setModelCode("");
            } else {
                meterDo.setModelCode(modelCode);
            }
            meterDo.setDevMeterStatus(1);
            meterDo.setDevMeterCommAddr(devMeterCommAddr);
            meterDo.setCtRate(ct);
            meterDo.setPtRate(pt);
            meterDo.setSelfRate(bd);
            if (StrUtil.isNotEmpty(prodDate)) {
                meterDo.setProdDate(DateUtil.parseDate(prodDate));
            }
            meterDo.setAccessGatewayId(0L);
            meterDo.setDevMeterCommAddr(devMeterCommAddr);
            if (mapR.isSuccess()) {
                meterDo.setDevMeterCommMode(ObjectUtil.isEmpty(mapR.getData().get(modelCode))
                        || StrUtil.isEmpty(mapR.getData().get(modelCode).getCodeContent1()) ? null : mapR.getData().get(modelCode).getCodeContent1());
                meterDo.setDevMeterCommProto(ObjectUtil.isEmpty(mapR.getData().get(modelCode))
                        || StrUtil.isEmpty(mapR.getData().get(modelCode).getCodeContent2()) ? null : mapR.getData().get(modelCode).getCodeContent2());
            }
            meterDo.setDevMeterName(devMeterName);
            meterDo.setDevMeterType(Integer.valueOf(res.getDevMeterType()));
            meterDo.setDevMeterNo(res.getDevMeterNo());
            meterDo.setSoftwareVersion(softwareVersion);
            meterDo.setHardwareVersion(hardwareVersion);
            meterDo.setCreator(AuthUtils.getUserNo());
            meterDo.setModifier(AuthUtils.getUserNo());
            meterDo.setMeasCommParam("{}");
            //meterDo.setDevMeterNo(queryRepeatMeterAddr(devMeterCommAddr));
            list.add(meterDo);
        }
        try {
            boolean b = gmDevMeterService.saveBatch(list);
            if (b) {
                return R.ok().msg("批量导入成功");
            }
            return R.failure().msg("表格数据有误，请检查模板是否正确");
        } catch (DuplicateKeyException ex) {
            // 判断异常信息是否包括
            if (Objects.requireNonNull(ex.getMessage()).contains("Duplicate entry")) {
                // 异常信息有空格，所以我们可以通过空格进行截取 获得一个数组
                String[] split = ex.getMessage().split(" ");
                String intercept = split[9];
                String[] split1 = intercept.split("-");
                String msg = split1[1] + "存在重复数据，导入失败";
                // 返回异常处理信息
                return R.failure().msg(msg);
            }
            return R.failure().msg("未知错误");
        }
    }

    public String queryRepeatMeterAddr(String devMeterCommAddr) {
        QueryWrapper<GmDevMeter> queryWrapper = new QueryWrapper<GmDevMeter>()
                .eq("dev_meter_comm_addr", devMeterCommAddr)
                .last("limit 1");
        GmDevMeter one = gmDevMeterService.getOne(queryWrapper);
        int no = 1;
        if (one != null) {
            String devMeterNo = one.getDevMeterNo();
            String[] devMeterNoArray = devMeterNo.split("-");
            if (devMeterNoArray.length > 1) {
                no = Integer.parseInt(devMeterNoArray[1]) + 1;
                return devMeterNoArray[0] + "-" + no;
            } else {
                return devMeterCommAddr + "-1";
            }
        }
        return devMeterCommAddr;
    }
}
