package com.gaea.iesms.bm.iot.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.gaea.base.core.R;
import com.gaea.base.enums.HandleCodeEnum;
import com.gaea.iesms.bm.iot.model.request.GmopsDevMeterRequest;
import com.gaea.iesms.bm.iot.service.GmopsDevMeterService;
import com.gaea.iesms.core.model.entity.iot.GmopsDevMeter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

@Api(tags = "量测表计设备工况")
@RestController
@RequestMapping("/gmopsDevMeter")
public class GmopsDevMeterController {

    @Resource
    private GmopsDevMeterService gmopsDevMeterService;

    /**
     * 查询量测表计设备工况
     */
    @GetMapping("/getGmopsDevMeter")
    @ApiOperation(value = "查询量测表计设备工况")
    public R<GmopsDevMeter> getGmopsDevMeter(@RequestParam("devMeterId") String devMeterId) {
        LambdaQueryWrapper<GmopsDevMeter> wrapper = new LambdaQueryWrapper<GmopsDevMeter>()
                .eq(StrUtil.isNotBlank(devMeterId), GmopsDevMeter::getDevMeterId, devMeterId)
                .last("LIMIT 1");
        return R.ok(gmopsDevMeterService.getOne(wrapper));
    }

    /**
     * 添加量测表计设备工况
     */
    @PostMapping("/addGmopsDevTerm")
    @ApiOperation(value = "添加量测表计设备工况")
    public R addGmopsDevTerm(@RequestBody GmopsDevMeter request) {
        boolean save = gmopsDevMeterService.save(request);
        if (save) {
            return R.enums(HandleCodeEnum.INSERT_SUCCESS);
        }
        return R.enums(HandleCodeEnum.INSERT_ERROR);
    }

    /**
     * 修改量测表计设备工况
     */
    @RequestMapping(value = "/saveOrUpdateGmopsDevTerm", method = {RequestMethod.POST, RequestMethod.PUT})
    @ApiOperation(value = "修改量测表计设备工况")
    public R saveOrUpdateGmopsDevTerm(@RequestBody GmopsDevMeterRequest request) {
        QueryWrapper<GmopsDevMeter> queryWrapper = new QueryWrapper<GmopsDevMeter>()
                .eq(request.getDevMeterId() != null, "dev_meter_id", request.getDevMeterId());
        GmopsDevMeter gmopsDevMeter = new GmopsDevMeter();
        BeanUtils.copyProperties(request, gmopsDevMeter);
        boolean update = gmopsDevMeterService.saveOrUpdate(gmopsDevMeter, queryWrapper);
        if (update) {
            return R.enums(HandleCodeEnum.MODIFY_SUCCESS);
        }
        return R.enums(HandleCodeEnum.MODIFY_ERROR);
    }

    /**
     * 删除量测表计设备工况
     */
    @RequestMapping(value = "/deleteGmopsDevTerm", method = {RequestMethod.POST, RequestMethod.DELETE})
    @ApiOperation(value = "删除量测表计设备工况")
    public R deleteGmopsDevTerm(@RequestBody GmopsDevMeterRequest request) {
        QueryWrapper<GmopsDevMeter> queryWrapper = new QueryWrapper<GmopsDevMeter>()
                .eq(request.getDevMeterId() != null, "dev_meter_id", request.getDevMeterId());
        GmopsDevMeter gmopsDevMeter = new GmopsDevMeter();
        BeanUtils.copyProperties(request, gmopsDevMeter);
        boolean update = gmopsDevMeterService.remove(queryWrapper);
        if (update) {
            return R.enums(HandleCodeEnum.MODIFY_SUCCESS);
        }
        return R.enums(HandleCodeEnum.MODIFY_ERROR);
    }
}
