package com.gaea.iesms.bm.iot.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.gaea.base.core.R;
import com.gaea.base.enums.HandleCodeEnum;
import com.gaea.iesms.core.feign.request.iot.GmopsDevTermDataRequest;
import com.gaea.iesms.bm.iot.model.request.GmopsDevTermRequest;
import com.gaea.iesms.core.feign.response.iot.GmopsDevTermDataInfo;
import com.gaea.iesms.bm.iot.service.GmopsDevTermService;
import com.gaea.iesms.core.model.entity.iot.GmopsDevTerm;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Map;

@Api(tags = "采集终端设备工况")
@RestController
@RequestMapping("/gmopsDevTerm")
public class GmopsDevTermController {

    @Resource
    private GmopsDevTermService gmopsDevTermService;

    /**
     * 查询资源和终端的装接信息
     *
     * @param request
     * @return
     */
    @GetMapping("/getTermGmopsDataInfo")
    public R<Map<Long, GmopsDevTermDataInfo>> getTermGmopsDataInfo(GmopsDevTermDataRequest request) {
        return R.ok(gmopsDevTermService.getTermGmopsDataInfo(request));
    }

    /**
     * 添加采集终端设备工况
     */
    @PostMapping("/addGmopsDevTerm")
    @ApiOperation(value = "添加采集终端设备工况")
    public R addGmopsDevTerm(@RequestBody GmopsDevTerm request) {
        boolean save = gmopsDevTermService.save(request);
        if (save) {
            return R.enums(HandleCodeEnum.INSERT_SUCCESS);
        }
        return R.enums(HandleCodeEnum.INSERT_ERROR);
    }

    /**
     * 修改采集终端设备工况
     */
    @RequestMapping(value = "/saveOrUpdateGmopsDevTerm", method = {RequestMethod.POST, RequestMethod.PUT})
    @ApiOperation(value = "修改采集终端设备工况")
    public R saveOrUpdateGmopsDevTerm(@RequestBody GmopsDevTermRequest request) {
        QueryWrapper<GmopsDevTerm> queryWrapper = new QueryWrapper<GmopsDevTerm>()
                .like(StrUtil.isNotBlank(request.getDevTermId()), "dev_term_id", request.getDevTermId());
        GmopsDevTerm gmopsDevTerm = new GmopsDevTerm();
        BeanUtils.copyProperties(request, gmopsDevTerm);
        boolean update = gmopsDevTermService.saveOrUpdate(gmopsDevTerm, queryWrapper);
        if (update) {
            return R.enums(HandleCodeEnum.MODIFY_SUCCESS);
        }
        return R.enums(HandleCodeEnum.MODIFY_ERROR);
    }

    /**
     * 删除采集终端设备工况
     */
    @RequestMapping(value = "/deleteGmopsDevTerm", method = {RequestMethod.POST, RequestMethod.DELETE})
    @ApiOperation(value = "删除采集终端设备工况")
    public R deleteGmopsDevTerm(@RequestBody GmopsDevTermRequest request) {
        QueryWrapper<GmopsDevTerm> queryWrapper = new QueryWrapper<GmopsDevTerm>()
                .eq(StrUtil.isNotBlank(request.getDevTermId()), "dev_term_id", request.getDevTermId());
        GmopsDevTerm gmopsDevTerm = new GmopsDevTerm();
        BeanUtils.copyProperties(request, gmopsDevTerm);
        boolean update = gmopsDevTermService.remove(queryWrapper);
        if (update) {
            return R.enums(HandleCodeEnum.DELETE_SUCCESS);
        }
        return R.enums(HandleCodeEnum.MODIFY_ERROR);
    }

}
