package com.gaea.iesms.bm.iot.controller;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.iot.mapper.InstCeResourceMapper;
import com.gaea.iesms.bm.iot.model.request.*;
import com.gaea.iesms.bm.iot.model.response.*;
import com.gaea.iesms.bm.iot.service.GmDevMeterService;
import com.gaea.iesms.bm.iot.service.GmDevTermService;
import com.gaea.iesms.bm.iot.service.InstCeResourceService;
import com.gaea.iesms.core.model.entity.iot.GmDevMeter;
import com.gaea.iesms.core.model.entity.iot.GmDevTerm;
import com.gaea.spring.cloud.starter.util.AuthUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 装接管理
 *
 * @author admin
 */
@Api(tags = "装接管理")
@RestController
@RequestMapping("/instCeResource")
public class InstCeResourceContrller {

    @Resource
    private InstCeResourceService instCeResourceService;

    @Resource
    private InstCeResourceMapper instCeResourceMapper;

    @Resource
    private GmDevTermService gmDevTermService;

    @Resource
    private GmDevMeterService gmDevMeterService;

    @ApiOperation(value = "分页查询用户列表")
    @GetMapping("/selectInstCeResourcePage")
    public R<InstCeResourcePageVo> selectInstCeResourcePage(InstCeResourceRequest request) {
        return R.ok(instCeResourceService.selectInstCeResourcePage(request));
    }

    @ApiOperation(value = "查询用户下终端列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "treeId", value = "用户标识（用来展开）", dataType = "String"),
            @ApiImplicitParam(name = "devTermNo", value = "终端编号（用来模糊搜索）", dataType = "String"),
            @ApiImplicitParam(name = "attached", value = "是否关联（true：已关联的  false：未关联的）", dataType = "String"),
    })
    @GetMapping("/selectInstCeResourceTermList")
    public R<List<InstCeResourceTermVo>> selectInstCeResourceTermList(InstCeResourceRequest request) {
        return R.ok(instCeResourceService.selectInstCeResourceTermList(request));
    }

    @ApiOperation(value = "查询终端下表计列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "treeId", value = "终端网关标识 termAccessGatewayId（用来展开）", dataType = "String"),
            @ApiImplicitParam(name = "ceResId", value = "用户标识", dataType = "String"),
            @ApiImplicitParam(name = "devMeterNo", value = "表计编号（用来模糊搜索）", dataType = "String"),
    })
    @GetMapping("/selectInstCeResourceMeterList")
    public R<List<InstCeResourceMeterVo>> selectInstCeResourceMeterList(InstCeResourceRequest request) {
        return R.ok(instCeResourceService.selectInstCeResourceMeterList(request));
    }

    @ApiOperation(value = "新增终端和用户关系")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "termIds-(termId)", value = "终端标识", dataType = "String"),
            @ApiImplicitParam(name = "resId", value = "用户id", dataType = "String"),
            @ApiImplicitParam(name = "installRemark", value = "安装位置", dataType = "String"),
            @ApiImplicitParam(name = "devTermName", value = "终端名称", dataType = "String"),
            @ApiImplicitParam(name = "devTermAddr", value = "终端地址", dataType = "String"),
    })
    @PostMapping("/addPointTermCeResource")
    public R<?> addPointTermCeResource(@RequestBody SaveTermCeResourceRequest request) {
        R r = instCeResourceService.addPointTermCeResource(request);
        if (r.getCode() == 200) {
            return R.ok().msg(r.getMsg());
        } else {
            return R.failure().msg(r.getMsg());
        }
    }

    @ApiOperation(value = "新增终端和表计关系")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "termAccessGatewayId", value = "终端网关标识", dataType = "String"),
            @ApiImplicitParam(name = "ceResId", value = "用户标识", dataType = "String"),
            @ApiImplicitParam(name = "meterId", value = "表计标识", dataType = "String"),
            @ApiImplicitParam(name = "devTermId", value = "终端标识", dataType = "String"),
            @ApiImplicitParam(name = "selfRate", value = "自身倍率", dataType = "String"),
            @ApiImplicitParam(name = "ctRate", value = "CT", dataType = "String"),
            @ApiImplicitParam(name = "ptRate", value = "PT", dataType = "String"),
            @ApiImplicitParam(name = "electricityTotal", value = "电量总", dataType = "String"),
            @ApiImplicitParam(name = "top", value = "尖", dataType = "String"),
            @ApiImplicitParam(name = "peak", value = "峰", dataType = "String"),
            @ApiImplicitParam(name = "flat", value = "平", dataType = "String"),
            @ApiImplicitParam(name = "valley", value = "谷", dataType = "String"),
    })
    @PostMapping("/addPointTermMeter")
    public R<?> addPointTermMeter(@RequestBody SaveTermMeterRequest request) {
        R r = instCeResourceService.addPointTermMeter(request);
        if (r.getCode() == 200) {
            return R.ok().msg(r.getMsg());
        } else {
            return R.failure().msg(r.getMsg());
        }
    }

    @ApiOperation(value = "修改终端和表计关系")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "termAccessGatewayId", value = "终端网关标识", dataType = "String"),
            @ApiImplicitParam(name = "ceResId", value = "用户标识", dataType = "String"),
            @ApiImplicitParam(name = "meterId", value = "表计标识", dataType = "String"),
            @ApiImplicitParam(name = "newMeterId", value = "新表计标识", dataType = "String"),
            @ApiImplicitParam(name = "devTermId", value = "终端标识", dataType = "String"),
            @ApiImplicitParam(name = "selfRate", value = "自身倍率", dataType = "String"),
            @ApiImplicitParam(name = "ctRate", value = "CT", dataType = "String"),
            @ApiImplicitParam(name = "ptRate", value = "PT", dataType = "String"),
            @ApiImplicitParam(name = "electricityTotal", value = "电量总", dataType = "String"),
            @ApiImplicitParam(name = "top", value = "尖", dataType = "String"),
            @ApiImplicitParam(name = "peak", value = "峰", dataType = "String"),
            @ApiImplicitParam(name = "flat", value = "平", dataType = "String"),
            @ApiImplicitParam(name = "valley", value = "谷", dataType = "String"),
            @ApiImplicitParam(name = "newElectricityTotal", value = "新电量总", dataType = "String"),
            @ApiImplicitParam(name = "newTop", value = "新尖", dataType = "String"),
            @ApiImplicitParam(name = "newPeak", value = "新峰", dataType = "String"),
            @ApiImplicitParam(name = "newFlat", value = "新平", dataType = "String"),
            @ApiImplicitParam(name = "newValley", value = "新谷", dataType = "String"),
    })
    @PostMapping("/updatePointTermMeter")
    public R<?> updatePointTermMeter(@RequestBody SaveTermMeterRequest request) {
        R r = instCeResourceService.updatePointTermMeter(request);
        if (r.getCode() == 200) {
            return R.ok().msg(r.getMsg());
        } else {
            return R.failure().msg(r.getMsg());
        }
    }

    @ApiOperation(value = "删除终端和表计关系")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "meterId", value = "表计标识", dataType = "String"),
            @ApiImplicitParam(name = "termAccessGatewayId", value = "终端网关标识", dataType = "String"),
            @ApiImplicitParam(name = "devTermId", value = "终端标识", dataType = "String"),
    })
    @PostMapping("/deletePointTermMeter")
    public R<?> deletePointTermMeter(@RequestBody SaveTermMeterRequest request) {
        R r = instCeResourceService.deletePointTermMeter(request);
        if (r.getCode() == 200) {
            return R.ok().msg(r.getMsg());
        } else {
            return R.failure().msg(r.getMsg());
        }
    }

    @ApiOperation(value = "删除终端和用户关系")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "termId", value = "终端标识", dataType = "String"),
            @ApiImplicitParam(name = "instPointTermId", value = "装接表标识", dataType = "String"),
            @ApiImplicitParam(name = "resId", value = "用户标识", dataType = "String"),
            @ApiImplicitParam(name = "termAccessGatewayId", value = "终端与表计连接的标识", dataType = "String"),
    })
    @PostMapping("/deletePointTermCeResource")
    public R<?> deletePointTermCeResource(@RequestBody SaveTermCeResourceRequest request) {
        R r = instCeResourceService.deletePointTermCeResource(request);
        if (r.getCode() == 200) {
            return R.ok().msg(r.getMsg());
        } else {
            return R.failure().msg(r.getMsg());
        }
    }

    /**
     * 判断表计是否已装接
     */
    @GetMapping("/selectMountingTermByMeterAddr")
    public R<?> selectMountingTermByMeterAddr(GmDevMeterRequest request) {
        return R.ok(instCeResourceMapper.selectMountingTermByMeterAddr(request.getDevMeterNo(), "", ""));
    }

    /**
     * 更新这个终端装接的信息
     */
    @PostMapping("/updateBatchInstCeResource")
    public R<?> updateBatchInstCeResource(@RequestBody SaveTermMeterRequest request) {
        return R.ok(instCeResourceService.updateBatchInstCeResource(request));
    }

    /**
     * 更换终端
     */
    @PostMapping("/replaceGmDevTerm")
    public R<?> replaceGmDevTerm(@RequestBody GmDevTermRequest request) {
        instCeResourceService.replaceGmDevTerm(request);
        return R.ok();
    }


    /**
     * 终端装接信息
     */
    @PostMapping("/insertBatchInstCeResource")
    public R<?> insertBatchInstCeResource(@RequestBody SaveTermMeterRequest request) {
        return R.ok(instCeResourceService.insertBatchInstCeResource(request));
    }

    /**
     * 查询终端上层节点（用户id）
     */
    @PostMapping("/queryTermUpperNode")
    public R<?> queryTermUpperNode(InstCeResourceRequest request) {
        return R.ok(instCeResourceMapper.queryTermUpperNode(request.getTermId(), request.getCeResId()));
    }


    /**
     * 批量装接导入
     */
    @ApiOperation(value = "批量导入")
    @PostMapping("/importTemplate")
    public R importTemplate(@RequestParam("file") MultipartFile file) {
        // 导入参数设置
        ImportParams params = new ImportParams();
        // 设置标题占用行数
        params.setTitleRows(0);
        // 设置表头占用行数
        params.setHeadRows(1);
        // 装接管理模板
        List<InstCeResourceManagement> templateList;
        try {
            templateList = ExcelImportUtil.importExcel(file.getInputStream(), InstCeResourceManagement.class, params);
        } catch (Exception e) {
            return R.failure().msg("找不到导入模板文件，错误原因是：" + e);
        }
        List<InstCeResourceManagement> collect = templateList.stream().filter(Objects::nonNull).filter(e -> StrUtil.isNotBlank(e.getCeCustNo())).collect(Collectors.toList());
        //判断表计编号是否重复，重复则返回重复的表计编号
        List<InstCeResourceManagement> devMeterNoList = getDevMeterNoList(collect);
        if (CollectionUtil.isNotEmpty(devMeterNoList)) {
            String resultMeterNo = "";
            for (InstCeResourceManagement item : devMeterNoList) {
                if (!"".equals(resultMeterNo)) {
                    resultMeterNo = resultMeterNo + "," + item.getDevMeterNo();
                } else {
                    resultMeterNo = item.getDevMeterNo();
                }
            }
            return R.failure().msg("表计编号为：" + resultMeterNo + "的值重复");
        }
        String orgNo = AuthUtils.getOrgNo();
        String userNo = AuthUtils.getUserNo();
        try {
            Set<String> userSet = new HashSet<>(16);
            for (InstCeResourceManagement item : collect) {
                //判断表计是否已装接
                int mountingCount = instCeResourceMapper.selectMountingTermByMeterAddr(item.getDevMeterNo(), "", "");
                if (mountingCount > 0) {
                    return R.failure().msg("表计编号：" + item.getDevMeterNo() + "已被装接");
                }
                String ceCustNo = item.getCeCustNo();
                String devMeterNo = item.getDevMeterNo();
                String devTermCommAddr = item.getDevTermCommAddr();
                BigDecimal electricityTotal = item.getElectricityTotal();
                BigDecimal top = item.getTop();
                BigDecimal peak = item.getPeak();
                BigDecimal flat = item.getFlat();
                BigDecimal valley = item.getValley();
                //根据用户编号、终端地址、表计地址查询出（用户标识、终端标识、终端网关、表计标识）
                Long termAccessGatewayId;
                Long termId;
                Long meterId;
                String userId = "";
                InstCeResourceRequest request = new InstCeResourceRequest();
                request.setOrgNo(orgNo);
                request.setUserNo(ceCustNo);
                request.setPageNumber(1);
                request.setPageSize(Integer.MAX_VALUE);
                if (StrUtil.isNotBlank(ceCustNo)) {
                    InstCeResourcePageVo pageVo = instCeResourceService.selectInstCeResourcePage(request);
                    List<InstCeResourceVo> list = pageVo.getList();
                    if (CollectionUtil.isEmpty(list)) {
                        return R.failure().msg("找不到用户编号为" + ceCustNo + "的用户");
                    }
                    userId = list.get(0).getUserId();
                } else {
                    return R.failure().msg("用户编号不能为空");
                }
                //判断终端地址是否为空，如果为空则不插入
                if (StrUtil.isNotBlank(devTermCommAddr)) {
                    QueryWrapper<GmDevTerm> queryWrapper = new QueryWrapper<GmDevTerm>()
                            .eq("dev_term_comm_addr", devTermCommAddr);
                    GmDevTerm one = gmDevTermService.getOne(queryWrapper);
                    if (ObjectUtil.isEmpty(one)) {
                        return R.failure().msg("找不到终端地址为" + devTermCommAddr + "的终端");
                    }
                    termAccessGatewayId = one.getAccessGatewayId();
                    termId = one.getId();
                } else {
                    return R.failure().msg("用户编号" + ceCustNo + "下的某个终端为空");
                }
                //判断表计编号是否为空，如果为空则不插入
                if (StrUtil.isNotBlank(devMeterNo)) {
                    QueryWrapper<GmDevMeter> queryWrapper = new QueryWrapper<GmDevMeter>()
                            .eq("dev_meter_no", devMeterNo);
                    GmDevMeter one = gmDevMeterService.getOne(queryWrapper);
                    if (one == null) {
                        return R.failure().msg("找不到表计编号为" + devMeterNo + "的表计");
                    }
                    meterId = one.getId();
                } else {
                    return R.failure().msg("用户编号" + ceCustNo + "下的某个表计为空");
                }
                SaveTermMeterRequest request1 = new SaveTermMeterRequest();
                request1.setCeResId(userId);
                request1.setMeterId(String.valueOf(meterId));
                request1.setDevTermId(String.valueOf(termId));
                request1.setTermAccessGatewayId(String.valueOf(termAccessGatewayId));
                request1.setUserNo(userNo);
                request1.setOrgNo(orgNo);
                request1.setInstaller(userNo);
                request1.setInstallTime(DateUtil.formatDateTime(new Date()));
                request1.setGotoRunner(userNo);
                request1.setGotoRunTime(DateUtil.formatDateTime(new Date()));
                JSONObject jsonObject = new JSONObject();
                jsonObject.set("gen_watt_paet", electricityTotal);
                jsonObject.set("gen_watt_paet1", top);
                jsonObject.set("gen_watt_paet2", peak);
                jsonObject.set("gen_watt_paet3", flat);
                jsonObject.set("gen_watt_paet4", valley);
                request1.setDevMeterStartReadingInfo(jsonObject.toString());
                String termUserId = ceCustNo + devTermCommAddr;
                int result = 1;
                if (userSet.contains(termUserId)) {
                    result = instCeResourceService.updateBatchInstCeResource(request1);
                } else {
                    String parentUserId = instCeResourceMapper.queryTermUpperNode(String.valueOf(termId), userId);
                    if (StrUtil.isNotBlank(parentUserId)) {
                        result = instCeResourceService.updateBatchInstCeResource(request1);
                        userSet.add(termUserId);
                    } else {
                        result = instCeResourceService.insertBatchInstCeResource(request1);
                        userSet.add(termUserId);
                    }
                }
                if (result == 0) {
                    return R.failure().msg("批量装接失败");
                }
            }
            return R.ok().msg("批量装接成功");
        } catch (Exception e) {
            e.printStackTrace();
            return R.failure().msg("批量装接失败");
        }
    }

    public List<InstCeResourceManagement> getDevMeterNoList(List<InstCeResourceManagement> templateList) {
        //用于存放重复的元素的list
        List<InstCeResourceManagement> repeatList = new ArrayList<>();
        Map<String, Integer> map = new HashMap<>();
        try {
            for (InstCeResourceManagement pojo : templateList) {
                //1:map.containsKey()   检测key是否重复
                String repeat = pojo.getDevMeterNo();
                if (map.containsKey(repeat)) {
                    repeatList.add(pojo);
                    Integer num = map.get(repeat);
                    map.put(repeat, num + 1);
                } else {
                    map.put(repeat, 1);
                }
            }
            return repeatList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() ->
                    new TreeSet<>(Comparator.comparing(InstCeResourceManagement::getDevMeterNo))), ArrayList::new));
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }


}
