package com.gaea.iesms.bm.iot.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.gaea.base.core.R;
import com.gaea.base.enums.HandleCodeEnum;
import com.gaea.iesms.bm.iot.model.request.InstPointMeterCeResourceRequest;
import com.gaea.iesms.bm.iot.service.InstPointMeterCeResourceService;
import com.gaea.iesms.core.model.entity.iot.InstPointMeterCeResource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

@Api(tags = "采集表计装接点（用能资源）")
@RestController
@RequestMapping("/instPointMeterCeResource")
public class InstPointMeterCeResourceController {

    @Resource
    private InstPointMeterCeResourceService instPointMeterCeResourceService;

    @PostMapping("/addInstPointMeterCeResource")
    @ApiOperation(value = "添加采集表计装接点（用能资源）")
    public R addInstPointMeterCeResource(@RequestBody InstPointMeterCeResourceRequest request) {
        InstPointMeterCeResource instPointMeterCeResource = new InstPointMeterCeResource();
        BeanUtils.copyProperties(request, instPointMeterCeResource);
        boolean save = instPointMeterCeResourceService.save(instPointMeterCeResource);
        if (save) {
            return R.enums(HandleCodeEnum.INSERT_SUCCESS);
        }
        return R.enums(HandleCodeEnum.INSERT_ERROR);
    }

    @RequestMapping(value = "/deleteInstPointMeterCeResource", method = {RequestMethod.POST, RequestMethod.DELETE})
    @ApiOperation(value = "删除采集表计装接点（用能资源）")
    public R deleteInstPointMeterCeResource(@RequestBody InstPointMeterCeResourceRequest request) {
        QueryWrapper<InstPointMeterCeResource> queryWrapper = new QueryWrapper<InstPointMeterCeResource>()
                .eq(StrUtil.isNotBlank(request.getDevMeterId()), "dev_meter_id", request.getDevMeterId())
                .eq(StrUtil.isNotBlank(request.getCeResId()), "ce_res_id", request.getCeResId());
        InstPointMeterCeResource instPointMeterCeResource = new InstPointMeterCeResource();
        BeanUtils.copyProperties(request, instPointMeterCeResource);
        boolean update = instPointMeterCeResourceService.remove(queryWrapper);
        if (update) {
            return R.enums(HandleCodeEnum.DELETE_SUCCESS);
        }
        return R.enums(HandleCodeEnum.MODIFY_ERROR);
    }

}
