package com.gaea.iesms.bm.iot.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.gaea.base.core.R;
import com.gaea.base.enums.HandleCodeEnum;
import com.gaea.iesms.bm.iot.model.request.InstPointTermCeResourceRequest;
import com.gaea.iesms.bm.iot.service.InstPointTermCeResourceService;
import com.gaea.iesms.core.model.entity.iot.InstPointTermCeResource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

@Api(tags = "采集终端装接点（用能资源）")
@RestController
@RequestMapping("/instPointTermCeResource")
public class InstPointTermCeResourceController {

    @Resource
    private InstPointTermCeResourceService instPointTermCeResourceService;

    @PostMapping("/addInstPointTermCeResource")
    @ApiOperation(value = "添加采集终端装接点（用能资源）")
    public R addInstPointTermCeResource(@RequestBody InstPointTermCeResourceRequest request) {
        InstPointTermCeResource instPointTermCeResource = new InstPointTermCeResource();
        BeanUtils.copyProperties(request, instPointTermCeResource);
        boolean save = instPointTermCeResourceService.save(instPointTermCeResource);
        if (save) {
            return R.enums(HandleCodeEnum.INSERT_SUCCESS);
        }
        return R.enums(HandleCodeEnum.INSERT_ERROR);
    }

    @RequestMapping(value = "/deleteInstPointTermCeResource", method = {RequestMethod.POST, RequestMethod.DELETE})
    @ApiOperation(value = "删除采集终端装接点（用能资源）")
    public R deleteInstPointTermCeResource(@RequestBody InstPointTermCeResourceRequest request) {
        QueryWrapper<InstPointTermCeResource> queryWrapper = new QueryWrapper<InstPointTermCeResource>()
                .eq(StrUtil.isNotBlank(request.getDevTermId()), "dev_term_id", request.getDevTermId())
                .eq(StrUtil.isNotBlank(request.getCeResId()), "ce_res_id", request.getCeResId());
        InstPointTermCeResource instPointTermCeResource = new InstPointTermCeResource();
        BeanUtils.copyProperties(request, instPointTermCeResource);
        boolean update = instPointTermCeResourceService.remove(queryWrapper);
        if (update) {
            return R.enums(HandleCodeEnum.DELETE_SUCCESS);
        }
        return R.enums(HandleCodeEnum.MODIFY_ERROR);
    }

}
