package com.gaea.iesms.bm.iot.controller;

import com.gaea.base.core.R;
import com.gaea.base.enums.HandleCodeEnum;
import com.gaea.iesms.bm.iot.service.LogDevMeterChangeService;
import com.gaea.iesms.core.model.entity.iot.LogDevMeterChange;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api(tags = "更换量测表计日志")
@RestController
@RequestMapping("/logDevMeterChange")
public class LogDevMeterChangeController {

    @Resource
    private LogDevMeterChangeService logDevMeterChangeService;

    /**
     * 新增-更换量测表计日志
     */
    @PostMapping("/addLogDevMeterChange")
    @ApiOperation(value = "新增-更换量测表计日志")
    public R addLogDevMeterChange(@RequestBody LogDevMeterChange request) {
        boolean save = logDevMeterChangeService.save(request);
        if (save) {
            return R.enums(HandleCodeEnum.INSERT_SUCCESS);
        }
        return R.enums(HandleCodeEnum.INSERT_ERROR);
    }
}
