package com.gaea.iesms.bm.iot.controller;

import com.gaea.base.core.R;
import com.gaea.base.enums.HandleCodeEnum;
import com.gaea.iesms.bm.iot.service.LogDevMeterInstallService;
import com.gaea.iesms.core.model.entity.iot.LogDevMeterInstall;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api(tags = "新增量测表计日志")
@RestController
@RequestMapping("/logDevMeterInstall")
public class LogDevMeterInstallController {

    @Resource
    private LogDevMeterInstallService logDevMeterInstallService;

    /**
     * 新增-量测表计日志
     */
    @PostMapping("/addLogDevMeterInstall")
    @ApiOperation(value = "新增-量测表计日志")
    public R addLogDevMeterInstall(@RequestBody LogDevMeterInstall request) {
        boolean save = logDevMeterInstallService.save(request);
        if (save) {
            return R.enums(HandleCodeEnum.INSERT_SUCCESS);
        }
        return R.enums(HandleCodeEnum.INSERT_ERROR);
    }
}
