package com.gaea.iesms.bm.iot.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gaea.iesms.bm.iot.model.response.CommunityConduitMeterInfoVo;
import com.gaea.iesms.bm.iot.model.response.CommunityConduitVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface CommunityConduitMapper {

    /**
     * 分页查询通讯工况列表
     */
    IPage<CommunityConduitVo> selectCommunityConduitPage(Page<CommunityConduitVo> page, @Param(Constants.WRAPPER) QueryWrapper<CommunityConduitVo> queryWrapper);

    /**
     * 查询挂表计的终端数量、在线离线数量、在线率信息
     */
    List<CommunityConduitVo> getCommunityConduitTermInfo(@Param(Constants.WRAPPER) QueryWrapper<CommunityConduitVo> queryWrapper);

    /**
     * 查询有工况表计的数量、在线离线数量、在线率信息
     */
    List<CommunityConduitVo> getCommunityMeterInfo(@Param(Constants.WRAPPER) QueryWrapper<CommunityConduitVo> queryWrapper);

    /**
     * 通过终端id和用户id获取表计在线离线列表
     */
    List<CommunityConduitMeterInfoVo> getCommunityConduitMeterInfo(@Param(Constants.WRAPPER) QueryWrapper<CommunityConduitVo> queryWrapper);
    IPage<CommunityConduitMeterInfoVo> getCommunityConduitMeterInfoPage(Page<CommunityConduitMeterInfoVo> page,@Param(Constants.WRAPPER) QueryWrapper<CommunityConduitMeterInfoVo> queryWrapper);
}
