package com.gaea.iesms.bm.iot.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gaea.iesms.bm.iot.model.response.GmDevTermVo;
import com.gaea.iesms.core.model.entity.iot.GmDevTerm;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 采集终端设备
 */
@Mapper
public interface GmDevTermMapper extends BaseMapper<GmDevTerm> {

    /**
     * 分页查询采集终端设备
     *
     * @return 分页查询结果
     */
    IPage<GmDevTermVo> selectGmDevTermPage(Page<GmDevTermVo> page, @Param(Constants.WRAPPER) QueryWrapper<GmDevTermVo> queryWrapper);

    /**
     * 根据终端id批量查询挂表的终端地址（用于终端批量删除）
     */
    List<String> getDevTermCommAddrByIds(@Param(Constants.WRAPPER) QueryWrapper<GmDevTermVo> queryWrapper);

}




