package com.gaea.iesms.bm.iot.model.request;

import com.baomidou.mybatisplus.annotation.TableName;
import com.gaea.base.core.PageQuery;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.util.List;

/**
 * 关联表计参数
 *
 * @author admin
 */
@Data
@EqualsAndHashCode(callSuper = true)
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(value = "关联表计参数")
public class AssocGmDevMeterRequest extends PageQuery {

    @ApiModelProperty(value = "系统单位编号")
    private String orgNo;

    @ApiModelProperty(value = "用户id")
    private String ceCustId;

    @ApiModelProperty(value = "采集终端编号")
    private String devTermNo;

    @ApiModelProperty(value = "采集终端名称")
    private String devTermName;

    @ApiModelProperty(value = "采集终端地址")
    private String devTermCommAddr;

    @ApiModelProperty(value = "量测表计名称")
    private String devMeterName;

    @ApiModelProperty(value = "量测通信地址")
    private String devMeterCommAddr;

    @ApiModelProperty(value = "1-获取待装接且未关联用能点的表计信息；3-已装接的表计信息")
    private String flag;

    /**
     * 量测表计类型 1 – 电表；
     * 2 – 水表；
     * 3 – 气表；
     * 4 – 热表；
     * 5 - 汽表；
     */
    private String devMeterType;

    /**
     * 表计id集合
     */
    private List<String> devMeterIdList;

    /**
     * 是否剔除关联过的表计
     */
    private String isExcludeManage;
}
