package com.gaea.iesms.bm.iot.model.request;

import com.baomidou.mybatisplus.annotation.TableName;
import com.gaea.base.core.PageQuery;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

/**
 * 量测表计设备分页请求类
 *
 * @author Administrator
 * @version 1.0
 * @date 2023/3/27 9:15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(value = "GmDevMeterPageRequest对象", description = "量测表计设备分页请求类")
public class GmDevMeterPageRequest extends PageQuery {

    @ApiModelProperty(value = "系统单位编号")
    private String orgNo;

    @ApiModelProperty(value = "采集终端编号")
    private String devTermNo;

    @ApiModelProperty(value = "采集终端名称")
    private String devTermName;

    @ApiModelProperty(value = "采集终端地址")
    private String devTermCommAddr;

    @ApiModelProperty(value = "量测表计名称")
    private String devMeterName;

    @ApiModelProperty(value = "量测通信地址")
    private String devMeterCommAddr;

    @ApiModelProperty(value = "量测表计状态 1 - 待装；2 - 待投；3 - 投运；4 - 故障；5 - 暂停；6 - 停运；7 - 拆除；", allowableValues = "1,2,3,4,5,6,7")
    private Integer devMeterStatus;

    @ApiModelProperty(value = "量测设备类型 1 – 电表；2 – 水表；3 – 气表；4 – 热表；5 - 汽表；6-环境传感器；7-光伏逆变器；8-储能PCS；9-智能断路器；99 - 其他；")
    private String devMeterType;

    @ApiModelProperty(value = "设备（表计）型号")
    private String modelCode;

    @ApiModelProperty(value = "量测表计编号")
    private String devMeterNo;

    @ApiModelProperty(value = "用能客户标识")
    private String ceCustId;
}
