package com.gaea.iesms.bm.iot.model.request;

import com.baomidou.mybatisplus.annotation.TableName;
import com.gaea.base.core.PageQuery;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

/**
 * @author Administrator
 * @version 1.0
 * @description: 采集终端设备请求类
 * @date 2023/3/23 16:54
 */
@Data
@EqualsAndHashCode(callSuper = true)
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(description = "采集终端设备分页请求类")
public class GmDevTermPageRequest extends PageQuery {

    @ApiModelProperty(value = "系统单位编号")
    private String orgNo;

    @ApiModelProperty(value = "采集终端Id")
    private String devTermId;

    @ApiModelProperty(value = "采集终端编号")
    private String devTermNo;

    @ApiModelProperty(value = "采集终端名称")
    private String devTermName;

    @ApiModelProperty(value = "采集终端地址")
    private String devTermCommAddr;

    @ApiModelProperty(value = "采集终端状态;1 - 待装；2 - 待投；3 - 投运；4 - 故障；5 - 暂停；6 - 停运；7 - 拆除；")
    private Integer devTermStatus;

    @ApiModelProperty(value = "设备（终端）型号")
    private String modelCode;

    @ApiModelProperty(value = "用能客户标识")
    private String ceCustId;

    @ApiModelProperty(value = "用能客户名称")
    private String ceCustName;
}
