package com.gaea.iesms.bm.iot.model.request;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gaea.iesms.core.model.core.IesmsNormalEntity;
import com.gaea.iesms.core.model.enums.archive.DevTermCommModeEnum;
import com.gaea.iesms.core.model.enums.archive.DevTermCommProtoEnum;
import com.gaea.iesms.core.model.enums.archive.DevTermStatusEnum;
import com.gaea.iesms.core.model.jsonobject.archive.EncryptInfoJsonObject;
import com.gaea.iesms.core.model.jsonobject.iot.DevTermCommParamJsonObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.util.Date;
import java.util.List;

/**
 * @author Administrator
 * @version 1.0
 * @description: 采集终端设备请求类
 * @date 2023/3/23 16:54
 */
@EqualsAndHashCode(callSuper = true)
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(description = "采集终端设备请求类，用于在前端和控制层交互的数据传输对象")
public class GmDevTermRequest extends IesmsNormalEntity {

    @ApiModelProperty(value = "老终端id")
    private String oldTermId;

    @ApiModelProperty(value = "系统单位编号")
    private String orgNo;

    @ApiModelProperty(value = "采集终端编号")
    private String devTermNo;

    @ApiModelProperty(value = "采集终端名称")
    private String devTermName;

    /**
     * 采集终端状态
     *
     * @see DevTermStatusEnum
     */
    @ApiModelProperty(value = "采集终端状态;1 - 待装；2 - 待投；3 - 投运；4 - 故障；5 - 暂停；6 - 停运；7 - 拆除；")
    private Integer devTermStatus;

    /**
     * 采集终端通讯规约;
     *
     * @see DevTermCommProtoEnum
     */
    @ApiModelProperty(value = "采集终端通讯规约;GAEADCU - 佳和DCU规约终端；\nIEC104 - IEC104规约终端；\nQGDW1376_1 - 国电网1376.1规约终端；\nQZDJFAAL - 浙电现场管理与服务终端；")
    private String devTermCommProto;

    @ApiModelProperty(value = "采集终端通讯规约版本")
    private String devTermCommProtoVer;

    /**
     * 采集终端通讯方式;
     *
     * @see DevTermCommModeEnum
     */
    @ApiModelProperty(value = "采集终端通讯方式;1 - TCP；2 - UDP；")
    private Integer devTermCommMode;

    @ApiModelProperty(value = "采集终端通讯地址")
    private String devTermCommAddr;

    @ApiModelProperty(value = "采集终端通讯参数")
    private DevTermCommParamJsonObject devTermCommParam;

    @ApiModelProperty(value = "是否加密")
    private Integer isEncrypt;

    @ApiModelProperty(value = "加密方式")
    private String encryptType;

    @ApiModelProperty(value = "加密信息")
    private EncryptInfoJsonObject encryptInfo;

    @ApiModelProperty(value = "硬件版本")
    private String hardwareVersion;

    @ApiModelProperty(value = "软件版本")
    private String softwareVersion;

    @ApiModelProperty(value = "生产厂家")
    private String mfrCode;

    @ApiModelProperty(value = "生产批次")
    private String prodBatch;

    @ApiModelProperty(value = "生产日期")
    private String prodDate;

    @ApiModelProperty(value = "设备型号")
    private String modelCode;

    @ApiModelProperty(value = "SIM卡号")
    private String simNo;

    @ApiModelProperty(value = "IMEI号")
    private String imeiNo;

    @ApiModelProperty(value = "装接人")
    private String installer;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "装接时间")
    private Date installTime;

    @ApiModelProperty(value = "装接备注")
    private String installRemark;

    @ApiModelProperty(value = "投运人")
    private String gotorunner;

    @ApiModelProperty(value = "投运时间")
    private Date gotorunTime;

    @ApiModelProperty(value = "投运备注")
    private String gotorunRemark;

    @ApiModelProperty(value = "停运人")
    private String stoprunner;

    @ApiModelProperty(value = "停运时间")
    private Date stoprunTime;

    @ApiModelProperty(value = "拆除人")
    private String dismantler;

    @ApiModelProperty(value = "拆除日期")
    private Date dismantleTime;

    @ApiModelProperty(value = "拆除备注")
    private String dismantleRemark;

    @ApiModelProperty(value = "接入网关设备标识；采集终端投运后，后台自动注册采集平台接入网关设备，注册成功后回填入接入网关设备标识及量测点标识")
    private Long accessGatewayId;

    @ApiModelProperty(value = "量测点标识；采集终端投运后，后台自动注册采集平台接入网关设备，注册成功后回填入接入网关设备标识及量测点标识")
    private Long measPointId;

    /**
     * 终端id
     */
    private List<String> ids;

    /**
     * 网关id
     */
    private List<String> termAccessGatewayIds;

}
