package com.gaea.iesms.bm.iot.model.request;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.gaea.base.typehandler.JsonObjectTypeHandler;
import com.gaea.iesms.core.model.jsonobject.iot.MeasDataInfoSetJsonObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.math.BigDecimal;

@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(description = "量测表计设备工况")
public class GmopsDevMeterRequest {

    @ApiModelProperty(value = "量测表计标识")
    private Long devMeterId;

    @ApiModelProperty(value = "最近一次报文上行时间")
    private Long gmtMessageUp;

    @ApiModelProperty(value = "最近一次量测数据上行时间")
    private Long gmtMeasdataUp;

    @ApiModelProperty(value = "最近一次告警上行时间")
    private Long gmtAlarmUp;

    @ApiModelProperty(value = "最近一次抄表示数上行时间")
    private Long gmtReadingUp;

    @ApiModelProperty(value = "最近一次抄表示数值")
    private BigDecimal readingValue;

    @ApiModelProperty(value = "最近一次量测表计状态")
    private Integer meterStateOpen;

    @ApiModelProperty(value = "最近一次量测数据集")
    @TableField(value = "meas_data_info_set", typeHandler = JsonObjectTypeHandler.class)
    private MeasDataInfoSetJsonObject measDataInfoSet;

}
