package com.gaea.iesms.bm.iot.model.request;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(description = "采集终端设备工况")
public class GmopsDevTermRequest {

    @ApiModelProperty(value = "采集终端标识")
    private String devTermId;

    @ApiModelProperty(value = "最近一次在线时间")
    private Long gmtConnectedAt;

    @ApiModelProperty(value = "最近一次心跳通讯时间")
    private Long gmtHeartbeatUp;

    @ApiModelProperty(value = "最近一次报文上行时间")
    private Long gmtMessageUp;

    @ApiModelProperty(value = "最近一次量测数据上行时间")
    private Long gmtMeasdataUp;

    @ApiModelProperty(value = "最近一次告警上行时间")
    private Long gmtAlarmUp;
}
