package com.gaea.iesms.bm.iot.model.request;

import com.baomidou.mybatisplus.annotation.TableName;
import com.gaea.base.core.PageQuery;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

/**
 * 装接管理
 *
 * @author admin
 */
@Data
@EqualsAndHashCode(callSuper = true)
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(description = "装接管理")
public class InstCeResourceRequest extends PageQuery {

    @ApiModelProperty(value = "用户id/终端id/表计id/终端网关标识")
    private String treeId;

    @ApiModelProperty(value = "树节点")
    private String treeNode;

    @ApiModelProperty(value = "是否关联（true：已关联的  false：未关联的）")
    private boolean attached = true;
    /**
     * 单位编号
     */
    private String orgNo;

    @ApiModelProperty(value = "终端编号")
    private String devTermNo;

    @ApiModelProperty(value = "终端名称")
    private String devTermName;

    @ApiModelProperty(value = "表计编号")
    private String devMeterNo;

    @ApiModelProperty(value = "表计名称")
    private String devMeterName;
    /**
     * 表计类型
     */
    private String devMeterType;
    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称")
    private String username;
    /**
     * 终端标识
     */
    private String termId;
    /**
     * 用户编号
     */
    private String userNo;
    /**
     * 终端地址
     */
    private String termAddr;
    /**
     * 表计地址
     */
    private String meterAddr;
    /**
     * 用户标识
     */
    @ApiModelProperty(value = "用户标识")
    private String ceResId;
    /**
     * 区域数层级
     */
    private String level;
    /**
     * 区域数标识
     */
    private String neighborhoodId;

    @ApiModelProperty(value = "用电分类(1 - 高压；2 - 低压非居民；3 - 低压居民)")
    private String consSort;


}
