package com.gaea.iesms.bm.iot.model.request;

import com.baomidou.mybatisplus.annotation.TableName;
import com.gaea.iesms.core.model.core.IesmsNormalEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

@EqualsAndHashCode(callSuper = true)
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(description = "采集终端装接点（用能资源）")
public class InstPointTermCeResourceRequest extends IesmsNormalEntity {

    @ApiModelProperty(value = "系统单位编号")
    private String orgNo;

    @ApiModelProperty(value = "采集终端标识")
    private String devTermId;

    @ApiModelProperty(value = "用能资源标识")
    private String ceResId;

    @ApiModelProperty(value = "用能资源类别 1 - 用能客户；2 - 用能区域；3 - 用能容器；4 - 用能设备；")
    private Integer ceResClass;
}
