package com.gaea.iesms.bm.iot.model.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class CommunityConduitPageScreenInfoVo implements Serializable {

    @ApiModelProperty(value = "量测表计标识")
    private String id;

    @ApiModelProperty(value = "用户标识")
    private String ceCustId;

    @ApiModelProperty(value = "用户名称")
    private String ceCustName;

    @ApiModelProperty(value = "所属对象")
    private String belongObject;

    @ApiModelProperty(value = "量测表计编号")
    private String devMeterNo;

    @ApiModelProperty(value = "量测表计名称")
    private String devMeterName;

    @ApiModelProperty(value = "量测通信地址")
    private String devMeterCommAddr;

    @ApiModelProperty(value = "设备（表计）型号")
    private String modelCode;

    @ApiModelProperty(value = "量测表计状态 1 - 待装；2 - 待投；3 - 投运；4 - 故障；5 - 暂停；6 - 停运；7 - 拆除；", allowableValues = "1,2,3,4,5,6,7")
    private String devMeterStatus;

    @ApiModelProperty(value = "CT倍率")
    private BigDecimal ctRate;

    @ApiModelProperty(value = "PT倍率")
    private BigDecimal ptRate;

    @ApiModelProperty(value = "倍率")
    private BigDecimal selfRate;

    @ApiModelProperty(value = "生产厂家")
    private String mfrCode;

    @ApiModelProperty(value = "生产厂家名称")
    private String mfrName;

    @ApiModelProperty(value = "生产批次")
    private String prodBatch;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "投运时间")
    private Date gotorunTime;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty(value = "生产日期")
    private Date prodDate;

    /**
     * 容量
     */
    private String capacity;

    /*
    * 倍率
     */
    private String essCRate;

    /**
     * 额定功率
     */
    private String ratedPower;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "最后通讯时间")
    private Date lastCommunityTime;

    @ApiModelProperty(value = "表计在线离线状态;1 - 在线；2 - 离线")
    private Integer onlineOffInState;

}
