package com.gaea.iesms.bm.iot.service;

import com.gaea.iesms.bm.iot.model.request.CommunityConduitPageRequest;
import com.gaea.iesms.bm.iot.model.response.*;

import java.util.List;
import java.util.Map;

public interface CommunityConduitService {

    /**
     * 分页查询通讯工况列表
     */
    CommunityConduitPageVo selectCommunityConduitPage(CommunityConduitPageRequest request);

    /**
     * 查询挂表计的终端数量、在线离线数量、在线率信息
     */
    Map<String, Object> getCommunityConduitTermInfo(CommunityConduitPageRequest request);

    /**
     * 查询有工况表计的数量、在线离线数量、在线率信息
     */
    List<CommunityConduitVo> getCommunityMeterInfo(CommunityConduitPageRequest request);

    /**
     * 获取表计在线离线信息
     */
    List<CommunityConduitMeterInfoVo> getCommunityConduitMeterInfo(List<String> devMeterIdList);

    /**
     * 工况统计数据
     * @param ceCustId
     * @param type
     * @return
     */
    TermMeasCommunityConduitVo termMeasCommunityConduit(String ceCustId, String type);

    CommunityConduitPageScreenVo selectCommunityConduitPageScreenMeas(CommunityConduitPageRequest request);
}
