package com.gaea.iesms.bm.iot.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.service.IService;
import com.gaea.iesms.bm.iot.model.request.GmDevTermPageRequest;
import com.gaea.iesms.bm.iot.model.response.GmDevTermPageVo;
import com.gaea.iesms.bm.iot.model.response.GmDevTermVo;
import com.gaea.iesms.core.model.entity.iot.GmDevTerm;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 针对表【gm_dev_term(采集终端设备;包括国电网1376.1规约终端、浙电现场管理与服务终端、佳和DCU规约终端、IEC104规约终端等；)】的数据库操作Service
 *
 * @author Administrator
 * @createDate 2023-03-07 11:13:41
 */
public interface GmDevTermService extends IService<GmDevTerm> {

    /**
     * 分页查询采集终端设备
     * @return 分页查询结果
     */
    GmDevTermPageVo selectGmDevTermPage(GmDevTermPageRequest request);

    /**
     * 根据终端id批量查询挂表的终端地址（用于终端批量删除）
     */
    List<String> getDevTermCommAddrByIds(@Param(Constants.WRAPPER) QueryWrapper<GmDevTermVo> queryWrapper);

}
