package com.gaea.iesms.bm.iot.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaea.base.core.R;
import com.gaea.base.error.BizException;
import com.gaea.iesms.bm.iot.mapper.GmDevCameraMapper;
import com.gaea.iesms.bm.iot.mapper.InstPointCameraCeResourceMapper;
import com.gaea.iesms.bm.iot.model.request.GmDevCameraInsertOrUpdateRequest;
import com.gaea.iesms.bm.iot.model.request.GmDevCameraQueryRequest;
import com.gaea.iesms.bm.iot.model.response.GmDevCameraTreeVo;
import com.gaea.iesms.bm.iot.model.response.GmDevCameraVo;
import com.gaea.iesms.bm.iot.service.GmDevCameraService;
import com.gaea.iesms.bm.iot.service.GmDevMeterService;
import com.gaea.iesms.core.feign.service.RemoteArchiveService;
import com.gaea.iesms.core.model.entity.archive.CeResource;
import com.gaea.iesms.core.model.entity.iot.GmDevCamera;
import com.gaea.iesms.core.model.entity.iot.GmDevMeter;
import com.gaea.iesms.core.model.entity.iot.InstPointCameraCeResource;
import com.gaea.iesms.core.model.jsonobject.iot.GmDevCameraParamJsonObject;
import com.gaea.spring.cloud.starter.component.redis.util.RedisUtils;
import com.gaea.spring.cloud.starter.util.AuthUtils;
import com.gaea.utils.ObjectUtils;
import com.gaea.utils.StringUtils;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2024/4/1
 */
@Service
public class GmDevCameraServiceImpl extends ServiceImpl<GmDevCameraMapper, GmDevCamera> implements GmDevCameraService {

    @Resource
    private InstPointCameraCeResourceMapper instPointCameraCeResourceMapper;

    @Resource
    private RemoteArchiveService remoteArchiveService;

    @Resource
    private GmDevMeterService gmDevMeterService;

    @Override
    public void insertOrUpdate(GmDevCameraInsertOrUpdateRequest request) {

        LambdaQueryWrapper<GmDevCamera> lambdaQueryWrapper = Wrappers.<GmDevCamera>lambdaQuery()
                .eq(GmDevCamera::getMondevSerialNo, request.getMondevSerialNo())
                .eq(GmDevCamera::getMondevChannelNo, request.getMondevChannelNo());
        int count = count(lambdaQueryWrapper);

        if (request.getId() == null) {

            if (count > 0) {
                throw BizException.of("该序列号与通道号相加已重复，请修改后再行添加");
            }

            GmDevCamera gmDevCamera = Convert.convert(GmDevCamera.class, request);
            gmDevCamera.setOrgNo(AuthUtils.getOrgNo());
            gmDevCamera.setMondevStatus(1);

            GmDevCameraParamJsonObject paramJsonObject = new GmDevCameraParamJsonObject();
            paramJsonObject.setMeterIdList(request.getMeterIdList());
            gmDevCamera.setMondevParam(paramJsonObject);

            save(gmDevCamera);

            InstPointCameraCeResource resource = new InstPointCameraCeResource();
            resource.setOrgNo(gmDevCamera.getOrgNo());
            resource.setCeResId(request.getCeResId());
            resource.setMondevId(gmDevCamera.getId());
            resource.setCeResClass(1);

            instPointCameraCeResourceMapper.insert(resource);
        } else {
            GmDevCamera gmDevCamera = getById(request.getId());
            if (gmDevCamera == null) {
                return;
            }

            if (count > 0) {
                if (!StringUtils.equals(request.getMondevSerialNo(), gmDevCamera.getMondevSerialNo()) || !ObjectUtils.equals(request.getMondevChannelNo(), gmDevCamera.getMondevChannelNo())) {
                    throw BizException.of("该序列号与通道号相加已重复，请修改后再行添加");
                }
            }

            ObjectUtils.copyProperties(request, gmDevCamera);

            GmDevCameraParamJsonObject paramJsonObject = new GmDevCameraParamJsonObject();
            paramJsonObject.setMeterIdList(request.getMeterIdList());
            gmDevCamera.setMondevParam(paramJsonObject);

            updateById(gmDevCamera);

            InstPointCameraCeResource resource = new InstPointCameraCeResource();
            resource.setCeResId(request.getCeResId());
            LambdaQueryWrapper<InstPointCameraCeResource> queryWrapper = Wrappers.<InstPointCameraCeResource>lambdaQuery()
                    .eq(InstPointCameraCeResource::getMondevId, gmDevCamera.getId());
            instPointCameraCeResourceMapper.update(resource, queryWrapper);
        }
    }

    @Override
    public IPage<GmDevCameraVo> query(GmDevCameraQueryRequest request) {
        IPage<GmDevCamera> iPage = new Page<>(request.getPageNumber(), request.getPageSize());
        LambdaQueryWrapper<GmDevCamera> lambdaQueryWrapper = Wrappers.<GmDevCamera>lambdaQuery()
                .eq(GmDevCamera::getOrgNo, AuthUtils.getOrgNo())
                .eq(request.getMondevStatus() != null, GmDevCamera::getMondevStatus, request.getMondevStatus())
                .like(StringUtils.isNotBlank(request.getMondevName()), GmDevCamera::getMondevName, request.getMondevName())
                .orderByDesc(GmDevCamera::getGmtCreate);
        iPage = page(iPage, lambdaQueryWrapper);
        return iPage.convert(item -> {
            GmDevCameraVo vo = Convert.convert(GmDevCameraVo.class, item);
            vo.setMondevTypeName(RedisUtils.util.get("VPP_CODE:VPP_CAMERA_TYPE:" + item.getMondevType(), String.class));
            vo.setMondevBrandName(RedisUtils.util.get("VPP_CODE:VPP_CAMERA_BRAND:" + item.getMondevBrand(), String.class));
            vo.setMondevProtoName(RedisUtils.util.get("VPP_CODE:VPP_CAMERA_PROTO:" + item.getMondevProto(), String.class));
            vo.setMondevStatusName(RedisUtils.util.get("VPP_CODE:VPP_STATUS:" + item.getMondevStatus(), String.class));

            LambdaQueryWrapper<InstPointCameraCeResource> queryWrapper = Wrappers.<InstPointCameraCeResource>lambdaQuery()
                    .eq(InstPointCameraCeResource::getMondevId, item.getId());
            InstPointCameraCeResource resource = instPointCameraCeResourceMapper.selectOne(queryWrapper);
            if (resource != null) {
                vo.setCeResId(resource.getCeResId());
                R<CeResource> result = remoteArchiveService.getCeResource(resource.getCeResId().toString());
                if (result.isSuccess()) {
                    vo.setCeResName(result.getData().getCeResName());
                }
            }

            List<Long> meterIdList = item.getMondevParam().getMeterIdList();
            if (CollectionUtil.isNotEmpty(meterIdList)) {
                List<Map<String, Object>> meterList = new ArrayList<>();
                for (Long meterId : meterIdList) {
                    GmDevMeter gmDevMeter = gmDevMeterService.getById(meterId);
                    if (gmDevMeter != null) {
                        Map<String, Object> map = Maps.newHashMap();
                        map.put("id", gmDevMeter.getId());
                        map.put("devMeterName", gmDevMeter.getDevMeterName());
                        map.put("devMeterCommAddr", gmDevMeter.getDevMeterCommAddr());
                        meterList.add(map);
                    }
                }
                vo.setMeterList(meterList);
            }
            return vo;
        });
    }

    @Override
    public List<GmDevCameraTreeVo> tree() {
        GmDevCameraQueryRequest request = new GmDevCameraQueryRequest();
        request.setMondevStatus(3);
        List<GmDevCameraVo> records = query(request).getRecords();

        List<GmDevCameraTreeVo> treeVoList = new ArrayList<>();

        Map<Long, List<GmDevCameraVo>> collect = records.stream().collect(Collectors.groupingBy(GmDevCameraVo::getCeResId));
        collect.forEach((key, val) -> {
            GmDevCameraTreeVo vo = new GmDevCameraTreeVo();
            vo.setCeResId(key);
            vo.setCeResName(val.get(0).getCeResName());
            vo.setList(val);
            treeVoList.add(vo);
        });
        return treeVoList;
    }
}
