package com.gaea.iesms.bm.iot;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/4/11
 */
@EnableDiscoveryClient
@EnableFeignClients(basePackages = "com.gaea.iesms.core.feign.**")
@SpringBootApplication(scanBasePackages = {"com.gaea.iesms.bm.iot.**", "com.gaea.spring.cloud.starter.**"})
public class IotStarter {

    public static void main(final String... args) {
        try {
            SpringApplication.run(IotStarter.class, args);
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
}
