package com.gaea.iesms.bm.iot.controller;

import com.gaea.base.core.R;
import com.gaea.iesms.bm.iot.service.DataCenterGmDevMeterService;
import com.iesms.bizprocessors.common.request.GmDevMeterGetRequest;
import com.iesms.bizprocessors.common.request.GmDevTermGetRequest;
import com.iesms.bizprocessors.common.request.GmopsDevMeterRefreshRequest;
import com.iesms.bizprocessors.common.request.GmopsDevTermRefreshRequest;
import com.iesms.bizprocessors.common.response.GmDevMeterGetResponse;
import com.iesms.bizprocessors.common.response.GmDevTermGetResponse;
import com.iesms.bizprocessors.common.response.GmopsDevMeterRefreshResponse;
import com.iesms.bizprocessors.common.response.GmopsDevTermRefreshResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author admin
 */
@Api(tags = "数据中心接口")
@RestController
@RequestMapping("/dataCenterGmDevMeter")
public class DataCenterGmDevMeterController {

    @Resource
    private DataCenterGmDevMeterService dataCenterGmDevMeterService;

    @GetMapping("/getGmDevMeter")
    @ApiOperation(value = "获取表计信息")
    public R<GmDevMeterGetResponse> getGmDevMeter(GmDevMeterGetRequest request) {
        return R.ok(dataCenterGmDevMeterService.getGmDevMeter(request));
    }

    @GetMapping("/getGmDevTerm")
    @ApiOperation(value = "获取终端信息")
    public R<GmDevTermGetResponse> getGmDevTerm(GmDevTermGetRequest request) {
        return R.ok(dataCenterGmDevMeterService.getGmDevTerm(request));
    }

    @GetMapping("/refreshGmopsDevTerm")
    @ApiOperation(value = "更新终端工况")
    public R<GmopsDevTermRefreshResponse> refreshGmopsDevTerm(GmopsDevTermRefreshRequest request) {
        return R.ok(dataCenterGmDevMeterService.refreshGmopsDevTerm(request));
    }

    @GetMapping("/refreshGmopsDevMeter")
    @ApiOperation(value = "更新表计工况")
    public R<GmopsDevMeterRefreshResponse> refreshGmopsDevMeter(GmopsDevMeterRefreshRequest request) {
        return R.ok(dataCenterGmDevMeterService.refreshGmopsDevMeter(request));
    }
}
