package com.gaea.iesms.bm.iot.controller;

import com.gaea.base.core.R;
import com.gaea.base.vo.PageDataVo;
import com.gaea.iesms.bm.iot.model.request.GmDevCameraInsertOrUpdateRequest;
import com.gaea.iesms.bm.iot.model.request.GmDevCameraQueryRequest;
import com.gaea.iesms.bm.iot.model.response.GmDevCameraTreeVo;
import com.gaea.iesms.bm.iot.model.response.GmDevCameraVo;
import com.gaea.iesms.bm.iot.service.GmDevCameraService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2024/4/1
 */
@Api(tags = "监控视频管理")
@RestController
@RequestMapping("gmDevCamera")
public class GmDevCameraController {

    @Resource
    private GmDevCameraService gmDevCameraService;

    @ApiOperation(value = "新增或编辑视频设备")
    @PostMapping
    public R<?> insertOrUpdate(@RequestBody GmDevCameraInsertOrUpdateRequest request) {
        gmDevCameraService.insertOrUpdate(request);
        return R.ok();
    }

    @ApiOperation(value = "分页查询视频设备列表")
    @GetMapping
    public R<PageDataVo<GmDevCameraVo>> query(GmDevCameraQueryRequest request) {
        return R.ok(gmDevCameraService.query(request));
    }

    @ApiOperation(value = "批量删除视频设备")
    @PostMapping("del")
    public R<Boolean> delete(@RequestBody List<Long> ids) {
        return R.ok(gmDevCameraService.removeByIds(ids));
    }

    @ApiOperation(value = "监控视频设备树")
    @GetMapping("tree")
    public R<List<GmDevCameraTreeVo>> tree() {
        return R.ok(gmDevCameraService.tree());
    }
}
