package com.gaea.iesms.bm.iot.controller;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.gaea.base.core.R;
import com.gaea.base.enums.HandleCodeEnum;
import com.gaea.iesms.bm.iot.model.request.GmDevMeterRequest;
import com.gaea.iesms.bm.iot.model.request.GmDevTermPageRequest;
import com.gaea.iesms.bm.iot.model.request.GmDevTermRequest;
import com.gaea.iesms.bm.iot.model.response.GmDevTermPageVo;
import com.gaea.iesms.bm.iot.model.response.GmDevTermVo;
import com.gaea.iesms.bm.iot.model.response.TermManagement;
import com.gaea.iesms.bm.iot.service.GmDevMeterService;
import com.gaea.iesms.bm.iot.service.GmDevTermService;
import com.gaea.iesms.core.feign.dto.SysCodeSortDTO;
import com.gaea.iesms.core.feign.request.SysCodeSortQueryRequest;
import com.gaea.iesms.core.feign.request.datacenter.GmDevTermCancelRequest;
import com.gaea.iesms.core.feign.request.datacenter.GmDevTermModifyRequest;
import com.gaea.iesms.core.feign.request.datacenter.GmDevTermRegisterRequest;
import com.gaea.iesms.core.feign.response.datacenter.GmDevTermCancelResponse;
import com.gaea.iesms.core.feign.response.datacenter.GmDevTermModifyResponse;
import com.gaea.iesms.core.feign.response.datacenter.GmDevTermRegisterResponse;
import com.gaea.iesms.core.feign.response.iot.GmDevMeterTermVo;
import com.gaea.iesms.core.feign.service.DataCenterCommonService;
import com.gaea.iesms.core.feign.service.RemoteSystemService;
import com.gaea.iesms.core.model.entity.iot.GmDevMeter;
import com.gaea.iesms.core.model.entity.iot.GmDevTerm;
import com.gaea.iesms.core.model.jsonobject.archive.MeasCommParamJsonObject;
import com.gaea.spring.cloud.starter.util.AuthUtils;
import com.gaea.utils.ExportUtil;
import com.gaea.utils.request.ExportRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author Administrator
 * @version 1.0
 * @description: TODO
 * @date 2023/3/23 16:43
 */
@Api(tags = "采集终端设备信息管理")
@RestController
@RequestMapping("/gmDevTerm")
public class GmDevTermController {

    private static final Logger LOGGER = LoggerFactory.getLogger(GmDevTermController.class);


    @Resource
    private GmDevTermService gmDevTermService;

    @Resource
    private GmDevMeterService gmDevMeterService;

    @Resource
    DataCenterCommonService dataCenterCommonService;

    @Resource
    RemoteSystemService remoteSystemService;

    /**
     * 添加采集终端设备信息
     *
     * @param request 采集终端设备信息
     * @return ResponseData
     */
    @PostMapping("/addGmDevTerm")
    @ApiOperation(value = "添加采集终端设备信息")
    public R addGmDevTerm(@RequestBody GmDevTermRequest request) {
        String orgNo = AuthUtils.getOrgNo();
        request.setOrgNo(orgNo);
        GmDevTerm gmDevTerm = new GmDevTerm();
        BeanUtils.copyProperties(request, gmDevTerm);
        //终端型号
        String modelCode = gmDevTerm.getModelCode();
        QueryWrapper<GmDevTerm> queryWrapper = new QueryWrapper<GmDevTerm>()
                .eq(StrUtil.isNotBlank(orgNo), "org_no", orgNo)
                .eq(StrUtil.isNotBlank(request.getDevTermNo()), "dev_term_no", request.getDevTermNo());
        int devTermNoCount = gmDevTermService.count(queryWrapper);
        if (devTermNoCount > 0) {
            return R.failure().msg("采集通信终端编号已重复");
        }
        if (StrUtil.isNotBlank(request.getDevTermCommAddr())) {
            QueryWrapper<GmDevTerm> queryWrapper1 = new QueryWrapper<GmDevTerm>()
                    .like(StrUtil.isNotBlank(orgNo), "org_no", orgNo)
                    .eq("dev_term_comm_addr", request.getDevTermCommAddr());
            long devTermCommAddrCount = gmDevTermService.list(queryWrapper1).stream()
                    .filter(e -> e.getDevTermCommAddr() != null && e.getDevTermCommAddr().equals(request.getDevTermCommAddr())).count();
            if (devTermCommAddrCount > 0) {
                return R.failure().msg("采集通信终端地址已重复");
            }
        }

        gmDevTerm.setDevTermStatus(1);
        gmDevTerm.setDevTermCommMode(1);
        gmDevTerm.setDevTermCommParam(new Object());
        gmDevTerm.setEncryptInfo(new Object());
        gmDevTerm.setCreator(AuthUtils.getUserNo());
        gmDevTerm.setGmtCreate(DateUtil.date().getTime());
        gmDevTerm.setProdDate(DateUtil.parseDate(request.getProdDate()));
        gmDevTerm.setIsValid(true);
        //code表获取采集终端通讯规约等信息接口
        SysCodeSortQueryRequest sysCodeSortQueryRequest = new SysCodeSortQueryRequest();
        sysCodeSortQueryRequest.setCodeSortNo("EMS_DEV_TERM_MODEL_CODE");
        sysCodeSortQueryRequest.setProjectCode("EMS_CODE");
        R<Map<String, SysCodeSortDTO>> mapR = remoteSystemService.queryCodeSort(sysCodeSortQueryRequest);
        if (mapR.isSuccess()) {
            gmDevTerm.setDevTermCommProto(ObjectUtil.isEmpty(mapR.getData().get(modelCode))
                    || StrUtil.isEmpty(mapR.getData().get(modelCode).getCodeContent1()) ? null : mapR.getData().get(modelCode).getCodeContent1());
            gmDevTerm.setDevTermCommProtoVer(ObjectUtil.isEmpty(mapR.getData().get(modelCode))
                    || StrUtil.isEmpty(mapR.getData().get(modelCode).getCodeContent2()) ? null : mapR.getData().get(modelCode).getCodeContent2());
            gmDevTerm.setDevTermCommMode(ObjectUtil.isEmpty(mapR.getData().get(modelCode))
                    || StrUtil.isEmpty(mapR.getData().get(modelCode).getCodeContent3()) ? null : Integer.getInteger(mapR.getData().get(modelCode).getCodeContent3()));
        }

        //调用feign接口获取接入网关设备标识和量测点标识
        GmDevTermRegisterRequest registerRequest = new GmDevTermRegisterRequest();
        registerRequest.setOrgNo(orgNo);
        //新增终端时，采集通信终端地址为采集通信终端编号
        registerRequest.setDevTermCommAddr(StrUtil.isNotEmpty(gmDevTerm.getDevTermCommAddr()) ? gmDevTerm.getDevTermCommAddr() : gmDevTerm.getDevTermNo());
        registerRequest.setDevTermCommMode(1);
        registerRequest.setDevTermCommProto(gmDevTerm.getDevTermCommProto());
        registerRequest.setDevTermCommProtoVer(gmDevTerm.getDevTermCommProtoVer());
        registerRequest.setDevTermName(gmDevTerm.getDevTermName());
        registerRequest.setDevTermNo(gmDevTerm.getDevTermNo());
        registerRequest.setMfrCode(gmDevTerm.getMfrCode());
        registerRequest.setModelCode(gmDevTerm.getModelCode());
        registerRequest.setEncryptInfo("{}");
        registerRequest.setDevTermCommParam("{}");
        registerRequest.setOperator(AuthUtils.getUserNo());
        LOGGER.info("新增终端registerRequest：" + registerRequest);
        R<GmDevTermRegisterResponse> registerResponse = dataCenterCommonService.registerGmDevTerm(registerRequest);
        LOGGER.info("新增终端registerResponse：" + registerResponse);
        if (registerResponse.isSuccess()) {
            gmDevTerm.setAccessGatewayId(registerResponse.getData().getAccessGatewayId());
            gmDevTerm.setMeasPointId(registerResponse.getData().getAcsampMeasPointId());
        } else {
            return R.failure().msg(registerResponse.getMsg());
        }
        boolean save = gmDevTermService.save(gmDevTerm);
        if (save) {
            return R.enums(HandleCodeEnum.INSERT_SUCCESS);
        }
        return R.enums(HandleCodeEnum.INSERT_ERROR);
    }

    /**
     * 修改采集终端设备信息
     *
     * @param request 采集终端设备信息
     * @return ResponseData
     */
    @RequestMapping(value = "/updateGmDevTerm", method = {RequestMethod.POST, RequestMethod.PUT})
    @ApiOperation(value = "修改采集终端设备信息")
    public R updateGmDevTerm(@RequestBody GmDevTermRequest request) {
        GmDevTerm gmDevTerm = gmDevTermService.getById(request.getId());

        Long accessGatewayId = gmDevTerm.getAccessGatewayId();
        if (ObjectUtil.isEmpty(gmDevTerm)) {
            return R.enums(HandleCodeEnum.SELECT_ERROR);
        }
        String orgNo = AuthUtils.getOrgNo();
        QueryWrapper<GmDevTerm> queryWrapper = new QueryWrapper<GmDevTerm>()
                .like(StrUtil.isNotBlank(orgNo), "org_no", orgNo)
                .eq(StrUtil.isNotBlank(request.getDevTermNo()), "dev_term_no", request.getDevTermNo());
        if (!StrUtil.equals(request.getDevTermNo(), gmDevTerm.getDevTermNo())) {
            int devTermNoCount = gmDevTermService.count(queryWrapper);
            if (devTermNoCount > 0) {
                return R.failure().msg("采集通信终端编号已重复");
            }
        }

        if (StrUtil.isNotBlank(request.getDevTermCommAddr())) {
            QueryWrapper<GmDevTerm> queryWrapper1 = new QueryWrapper<GmDevTerm>()
                    .like(StrUtil.isNotBlank(orgNo), "org_no", orgNo)
                    .eq("dev_term_comm_addr", request.getDevTermCommAddr());
            if (!StrUtil.equals(request.getDevTermCommAddr(), gmDevTerm.getDevTermCommAddr())) {
                long devTermCommAddrCount = gmDevTermService.list(queryWrapper1).stream()
                        .filter(e -> e.getDevTermCommAddr() != null && e.getDevTermCommAddr().equals(request.getDevTermCommAddr())).count();
                if (devTermCommAddrCount > 0) {
                    return R.failure().msg("采集通信终端地址已重复");
                }
            }
        }

        BeanUtils.copyProperties(request, gmDevTerm);

        gmDevTerm.setModifier(AuthUtils.getUserNo());
        gmDevTerm.setGmtInvalid(DateUtil.date().getTime());

        //调用feign接口 更新数据
        GmDevTermModifyRequest gmDevTermModifyRequest = new GmDevTermModifyRequest();
        gmDevTermModifyRequest.setAccessGatewayId(accessGatewayId);
        gmDevTermModifyRequest.setDevTermNo(gmDevTerm.getDevTermNo());
        gmDevTermModifyRequest.setDevTermCommAddr(StrUtil.isNotEmpty(gmDevTerm.getDevTermCommAddr()) ? gmDevTerm.getDevTermCommAddr() : gmDevTerm.getDevTermNo());
        gmDevTermModifyRequest.setDevTermCommMode(gmDevTerm.getDevTermCommMode());
        gmDevTermModifyRequest.setDevTermName(gmDevTerm.getDevTermName());
        gmDevTermModifyRequest.setDevTermCommProto(gmDevTerm.getDevTermCommProto());
        gmDevTermModifyRequest.setDevTermCommProtoVer(gmDevTerm.getDevTermCommProtoVer());
        gmDevTermModifyRequest.setMfrCode(gmDevTerm.getMfrCode());
        gmDevTermModifyRequest.setModelCode(gmDevTerm.getModelCode());
        gmDevTermModifyRequest.setOperator(AuthUtils.getUserNo());
        LOGGER.info("编辑终端gmDevTermModifyRequest：" + gmDevTermModifyRequest);
        R<GmDevTermModifyResponse> modifyResponseR = dataCenterCommonService.modifyGmDevTerm(gmDevTermModifyRequest);
        LOGGER.info("编辑终端modifyResponseR：" + modifyResponseR);
        boolean update = false;
        if (modifyResponseR.isSuccess()) {
            update = gmDevTermService.updateById(gmDevTerm);
        } else {
            return R.failure().msg(modifyResponseR.getMsg());
        }
        if (update) {
            return R.enums(HandleCodeEnum.MODIFY_SUCCESS);
        }
        return R.enums(HandleCodeEnum.MODIFY_ERROR);
    }

    /**
     * 批量删除采集终端设备信息
     */
    @ApiParam(name = "ids", value = "采集终端设备id集合", required = true)
    @RequestMapping(value = "/deleteGmDevTermById", method = {RequestMethod.POST, RequestMethod.DELETE})
    @ApiOperation(value = "批量删除采集终端设备信息")
    public R deleteGmDevTermById(@RequestBody GmDevTermRequest request) {
        List<String> termIds = request.getIds();
        List<String> termAccessGatewayIds = request.getTermAccessGatewayIds();
        String orgNo = AuthUtils.getOrgNo();
        QueryWrapper<GmDevTermVo> queryWrapper = new QueryWrapper<GmDevTermVo>()
                .like(StrUtil.isNotBlank(orgNo), "gdt.org_no", orgNo)
                .eq("gdt.dev_term_status", 3)
                .in("gdt.id", termIds);
        List<String> devTermCommAddrByIds = gmDevTermService.getDevTermCommAddrByIds(queryWrapper);
        if (devTermCommAddrByIds.size() > 0) {
            StringBuilder str = new StringBuilder();
            StringBuilder finalStr = str;
            devTermCommAddrByIds.forEach(item -> finalStr.append(item).append("，"));
            str = new StringBuilder(str.substring(0, str.length() - 1));
            return R.failure().msg("终端地址" + str + "下存在挂接的表计，不能拆除");
        }
        for (String item : termAccessGatewayIds) {
            GmDevTermCancelRequest gmDevTermCancelRequest = new GmDevTermCancelRequest();
            gmDevTermCancelRequest.setAccessGatewayId(Long.valueOf(item));
            gmDevTermCancelRequest.setOperator(AuthUtils.getUserNo());
            R<GmDevTermCancelResponse> responseR = dataCenterCommonService.cancelGmDevTerm(gmDevTermCancelRequest);
            if (!responseR.isSuccess()) {
                return R.failure().msg(responseR.getMsg());
            }
        }

        boolean delete = gmDevTermService.removeByIds(termIds);
        if (delete) {
            return R.enums(HandleCodeEnum.DELETE_SUCCESS);
        } else {
            return R.enums(HandleCodeEnum.DELETE_ERROR);
        }
    }

    /**
     * 分页查询采集终端设备
     */
    @ApiOperation(value = "分页查询采集终端设备")
    @GetMapping("/selectGmDevTermPage")
    public R<GmDevTermPageVo> selectGmDevTermPage(GmDevTermPageRequest request) {
        return R.ok(gmDevTermService.selectGmDevTermPage(request));
    }

    /**
     * 判断终端下是否有关联的该表计，如有则插入表计表，无则更新量测点id和接入网关设备标识
     */
    @ApiOperation(value = "自下而上新增或修改表计表")
    @PostMapping("/insertOrUpdateGmDevMeter")
    public R insertOrUpdateGmDevMeter(@RequestBody GmDevMeterRequest request) {

        GmDevTerm gmDevTerm = gmDevTermService.getOne(new QueryWrapper<GmDevTerm>().lambda().eq(GmDevTerm::getDevTermNo, request.getDevTermNo()));
        List<GmDevMeter> gmDevMeterList = gmDevMeterService.list(new QueryWrapper<GmDevMeter>().lambda()
                .eq(GmDevMeter::getAccessGatewayId, gmDevTerm.getAccessGatewayId()));
        List<String> devMeterNoList = gmDevMeterList.stream().map(GmDevMeter::getDevMeterNo).collect(Collectors.toList());
        GmDevMeter gmDevMeter = new GmDevMeter();
        if (!devMeterNoList.contains(request.getDevMeterNo())) {
            BeanUtils.copyProperties(request, gmDevMeter);
            gmDevMeter.setMeasCommParam(new MeasCommParamJsonObject());
            gmDevMeterService.save(gmDevMeter);
        } else {
            Long id = gmDevMeterList.stream()
                    .filter(item -> Objects.equals(item.getDevMeterNo(), request.getDevMeterNo()))
                    .map(GmDevMeter::getId)
                    .findFirst()
                    .orElse(null);
            gmDevMeter.setId(id);
            gmDevMeter.setAccessMeasureId(request.getAccessMeasureId());
            gmDevMeter.setMeasPointId(request.getMeasPointId());
            gmDevMeter.setGmtModified(System.currentTimeMillis());
            gmDevMeterService.updateById(gmDevMeter);
        }
        return R.ok(HandleCodeEnum.HANDLE_SUCCESS);
    }

    /**
     * 根据终端号获取终端信息
     */
    @ApiOperation(value = "自下而上调用根据终端号获取终端信息")
    @GetMapping("/selectOneGmDevTerm")
    public R<GmDevTerm> selectOneGmDevTerm(@RequestParam("devTermNo") String devTermNo) {
        GmDevTerm gmDevTerm = gmDevTermService.getOne(new QueryWrapper<GmDevTerm>().lambda().eq(GmDevTerm::getDevTermNo, devTermNo));
        return R.ok(gmDevTerm);
    }

    /**
     * 导出excel
     */
    @ApiOperation(value = "Excel导出")
    @GetMapping("/export")
    public void export(GmDevTermPageRequest request) {
        GmDevTermPageVo iPage = gmDevTermService.selectGmDevTermPage(request);
        List<String> headers = Lists.newArrayList();
        headers.add("devTermNo-采集通信终端编号");
        headers.add("devTermName-采集通信终端名称");
        headers.add("devTermStatus-采集通信终端状态");
        headers.add("ceCustName-用能客户名称");
        headers.add("mfrName-生产厂家");
        headers.add("modelCode-设备型号");
        headers.add("simNo-运营商卡号");
        headers.add("installRemark-安装位置");
        ExportRequest build = ExportRequest.builder()
                .headers(headers)
                .list(iPage.getList())
                .filename("终端管理列表" + DateUtil.format(new Date(), "yyyy年MM月dd日"))
                .build();
        ExportUtil.export(build);
    }

    /**
     * 终端批量导入
     */
    @ApiOperation(value = "批量导入")
    @PostMapping(value = "/importTemplate")
    public R importTemplate(@RequestParam("file") MultipartFile file) {
        // 导入参数设置
        ImportParams params = new ImportParams();
        // 设置标题占用行数
        params.setTitleRows(2);
        // 设置表头占用行数
        params.setHeadRows(2);
        // 表计档案管理模板
        List<TermManagement> termManagementList;
        try {
            termManagementList = ExcelImportUtil.importExcel(file.getInputStream(), TermManagement.class, params);
        } catch (Exception e) {
            return R.failure().msg("找不到导入模板文件，错误原因是：" + e);
        }
        List<TermManagement> resList = termManagementList.stream()
                .filter(e -> StrUtil.isNotBlank(e.getMfrCode())).collect(Collectors.toList());
        List<GmDevTerm> collect = Lists.newArrayList();
        for (TermManagement item : resList) {
            if (StrUtil.isBlank(item.getDevTermNo())) {
                return R.failure().msg("采集通信终端编号不能为空");
            }
            if (StrUtil.isBlank(item.getDevTermName())) {
                return R.failure().msg("采集通信终端名称不能为空");
            }
            if (StrUtil.isBlank(item.getMfrCode())) {
                return R.failure().msg("生产厂家不能为空");
            }
            if (StrUtil.isBlank(item.getModelCode())) {
                return R.failure().msg("设备型号不能为空");
            }
            String orgNo = AuthUtils.getOrgNo();

            String devTermNo = item.getDevTermNo();
            String devTermCommAddr = item.getDevTermCommAddr();
            String modelCode = item.getModelCode();

            if (StrUtil.isNotBlank(devTermCommAddr)) {
                QueryWrapper<GmDevTerm> queryWrapper1 = new QueryWrapper<GmDevTerm>()
                        .like(StrUtil.isNotBlank(orgNo), "org_no", orgNo)
                        .eq("dev_term_comm_addr", devTermCommAddr);
                long devTermCommAddrCount = gmDevTermService.list(queryWrapper1).stream()
                        .filter(e -> e.getDevTermCommAddr() != null && e.getDevTermCommAddr().equals(devTermCommAddr)).count();
                if (devTermCommAddrCount > 0) {
                    return R.failure().msg("采集通信终端地址已重复");
                }
            }


            QueryWrapper<GmDevTerm> queryWrapper1 = new QueryWrapper<GmDevTerm>()
                    .like(StrUtil.isNotBlank(orgNo), "org_no", orgNo)
                    .eq("dev_term_no", devTermNo);
            int devTermNoCount = gmDevTermService.count(queryWrapper1);
            if (devTermNoCount > 0) {
                return R.failure().msg("采集通信终端编号已重复");
            }
            GmDevTerm gmDevTerm = new GmDevTerm();
            //code表获取采集终端通讯规约等信息接口
            SysCodeSortQueryRequest sysCodeSortQueryRequest = new SysCodeSortQueryRequest();
            sysCodeSortQueryRequest.setCodeSortNo("EMS_DEV_TERM_MODEL_CODE");
            sysCodeSortQueryRequest.setProjectCode("EMS_CODE");
            R<Map<String, SysCodeSortDTO>> mapR = remoteSystemService.queryCodeSort(sysCodeSortQueryRequest);
            if (mapR.isSuccess()) {
                gmDevTerm.setDevTermCommProto(ObjectUtil.isEmpty(mapR.getData().get(modelCode))
                        || StrUtil.isEmpty(mapR.getData().get(modelCode).getCodeContent1()) ? null : mapR.getData().get(modelCode).getCodeContent1());
                gmDevTerm.setDevTermCommProtoVer(ObjectUtil.isEmpty(mapR.getData().get(modelCode))
                        || StrUtil.isEmpty(mapR.getData().get(modelCode).getCodeContent2()) ? null : mapR.getData().get(modelCode).getCodeContent2());
                gmDevTerm.setDevTermCommMode(ObjectUtil.isEmpty(mapR.getData().get(modelCode))
                        || StrUtil.isEmpty(mapR.getData().get(modelCode).getCodeContent3()) ? null : Integer.getInteger(mapR.getData().get(modelCode).getCodeContent3()));
            }
            gmDevTerm.setOrgNo(AuthUtils.getOrgNo());
            if ("".equals(item.getMfrCode())) {
                gmDevTerm.setMfrCode("");
            } else {
                gmDevTerm.setMfrCode(item.getMfrCode());
            }
            gmDevTerm.setSimNo(item.getSimNo());
            gmDevTerm.setModelCode(modelCode);
            gmDevTerm.setDevTermCommAddr(item.getDevTermCommAddr());
            gmDevTerm.setCreator(AuthUtils.getUserNo());
            gmDevTerm.setModifier(AuthUtils.getUserNo());
            gmDevTerm.setDevTermNo(item.getDevTermNo());
            gmDevTerm.setDevTermName(item.getDevTermName());
            gmDevTerm.setGmtCreate(System.currentTimeMillis());
            gmDevTerm.setGmtModified(System.currentTimeMillis());
            gmDevTerm.setDevTermStatus(1);
            gmDevTerm.setDevTermCommMode(1);
            if (StrUtil.isBlank(gmDevTerm.getDevTermCommProto())) {
                gmDevTerm.setDevTermCommProtoVer("");
                gmDevTerm.setDevTermCommProto("GAEADCU");
            }
            if (StrUtil.isNotEmpty(item.getProdDate())) {
                gmDevTerm.setProdDate(DateUtil.parseDate(item.getProdDate()));
            }
            gmDevTerm.setInstallRemark(item.getInstallRemark());
            gmDevTerm.setDevTermCommParam(new Object());
            gmDevTerm.setEncryptInfo(new Object());
            //调用feign接口获取接入网关设备标识和量测点标识
            GmDevTermRegisterRequest registerRequest = new GmDevTermRegisterRequest();
            registerRequest.setOrgNo(AuthUtils.getOrgNo());
            registerRequest.setDevTermCommAddr(StrUtil.isNotEmpty(item.getDevTermCommAddr()) ? item.getDevTermCommAddr() : item.getDevTermNo());
            registerRequest.setDevTermCommMode(1);
            registerRequest.setDevTermCommProto(gmDevTerm.getDevTermCommProto());
            registerRequest.setDevTermCommProtoVer(gmDevTerm.getDevTermCommProtoVer());
            registerRequest.setDevTermName(gmDevTerm.getDevTermName());
            registerRequest.setDevTermNo(gmDevTerm.getDevTermNo());
            registerRequest.setMfrCode(gmDevTerm.getMfrCode());
            registerRequest.setModelCode(gmDevTerm.getModelCode());
            registerRequest.setEncryptInfo("{}");
            registerRequest.setDevTermCommParam("{}");
            registerRequest.setOperator(AuthUtils.getUserNo());
            R<GmDevTermRegisterResponse> registerResponse = dataCenterCommonService.registerGmDevTerm(registerRequest);
            if (registerResponse.isSuccess()) {
                gmDevTerm.setAccessGatewayId(registerResponse.getData().getAccessGatewayId());
                gmDevTerm.setMeasPointId(registerResponse.getData().getAcsampMeasPointId());
            } else {
                return R.failure().msg(registerResponse.getMsg());
            }
            collect.add(gmDevTerm);
        }
        try {
            boolean b = gmDevTermService.saveBatch(collect);
            if (b) {
                return R.ok().msg("批量导入成功");
            }
            return R.failure().msg("表格数据有误，请检查模板是否正确");
        } catch (DuplicateKeyException ex) {
            // 判断异常信息是否包括
            if (Objects.requireNonNull(ex.getMessage()).contains("Duplicate entry")) {
                // 异常信息有空格，所以我们可以通过空格进行截取 获得一个数组
                String[] split = ex.getMessage().split(" ");
                String intercept = split[9];
                String[] split1 = intercept.split("-");
                String msg = split1[1] + "存在重复数据，导入失败";
                // 返回异常处理信息
                return R.failure().msg(msg);
            }
            return R.failure().msg("未知错误");
        }
    }

    @ApiOperation(value = "根据表计id查询表计终端相关信息")
    @GetMapping("/getDevTermMeterList")
    public R<List<GmDevMeterTermVo>> getDevTermMeterList(@RequestParam("meterIds") List<String> meterIds) {
       return R.ok(gmDevMeterService.getDevTermMeterList(meterIds));
    }

}
