package com.gaea.iesms.bm.iot.controller;

import com.gaea.base.core.R;
import com.gaea.base.enums.HandleCodeEnum;
import com.gaea.iesms.bm.iot.service.LogDevMeterDismantleService;
import com.gaea.iesms.core.model.entity.iot.LogDevMeterDismantle;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api(tags = "拆除量测表计日志")
@RestController
@RequestMapping("/logDevMeterDismantle")
public class LogDevMeterDismantleController {

    @Resource
    private LogDevMeterDismantleService logDevMeterDismantleService;

    /**
     * 新增-拆除量测表计日志
     */
    @PostMapping("/addLogDevMeterDismantle")
    @ApiOperation(value = "新增-拆除量测表计日志")
    public R addLogDevMeterDismantle(@RequestBody LogDevMeterDismantle request) {
        boolean save = logDevMeterDismantleService.save(request);
        if (save) {
            return R.enums(HandleCodeEnum.INSERT_SUCCESS);
        }
        return R.enums(HandleCodeEnum.INSERT_ERROR);
    }
}
