package com.gaea.iesms.bm.iot.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gaea.iesms.bm.iot.model.request.AssocGmDevMeterRequest;
import com.gaea.iesms.bm.iot.model.response.GmDevMeterVo;
import com.gaea.iesms.core.model.entity.iot.GmDevMeter;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 量测表计设备
 */
@Mapper
public interface GmDevMeterMapper extends BaseMapper<GmDevMeter> {


    /**
     * 分页查询量测表计设备列表
     */
    IPage<GmDevMeterVo> selectGmDevMeterPage(Page<GmDevMeterVo> page, @Param(Constants.WRAPPER) QueryWrapper<GmDevMeterVo> queryWrapper);

    /**
     * 查询关联表计列表
     */
    List<GmDevMeterVo> getAssocGmDevMeterList(@Param("params") AssocGmDevMeterRequest request);

    /**
     * 根据量测点查询工况采集时间
     */
    String getGmtMessageUp(String measPointId);

    /**
     * 根据资源id查询关联的表计信息
     */
    GmDevMeter getGmDevMeterByResId(@Param("params") AssocGmDevMeterRequest request);



}




