package com.gaea.iesms.bm.iot.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gaea.iesms.bm.iot.model.request.InstCeResourceRequest;
import com.gaea.iesms.bm.iot.model.response.InstCeResourceMeterVo;
import com.gaea.iesms.bm.iot.model.response.InstCeResourceTermVo;
import com.gaea.iesms.bm.iot.model.response.InstCeResourceVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 装接管理
 *
 * @author admin
 */
@Mapper
public interface InstCeResourceMapper {

    /**
     * 分页查询装接用户列表
     */
    IPage<InstCeResourceVo> selectInstCeResourcePage(Page<InstCeResourceVo> page
            , @Param(Constants.WRAPPER) QueryWrapper<InstCeResourceVo> queryWrapper);

    /**
     * 查询用户下终端列表
     */
    List<InstCeResourceTermVo> selectInstCeResourceTermList(InstCeResourceRequest request);

    /**
     * 查询用户下未关联终端列表
     * 4月9日  经管理商量去掉限制，将终端都查出来（一个用户下可以关联多个终端）
     */
    List<InstCeResourceTermVo> queryTerminalByUser(InstCeResourceRequest request);

    /**
     * 查询终端下是否存在表计
     */
    List<String> queryMeterTotalByTermId(@Param("termAccessGatewayId") String termAccessGatewayId, @Param("ceResId") String ceResId);

    /**
     * 查询终端上层节点（用户id）
     */
    String queryTermUpperNode(@Param("termId") String termId, @Param("resId") String resId);

    /**
     * 查询终端下表计列表
     */
    List<InstCeResourceMeterVo> selectInstCeResourceMeterList(InstCeResourceRequest request);

    /**
     * 查询终端下装接表计的信息
     */
    List<InstCeResourceMeterVo> queryMeterByTerminalOnIsAttached(InstCeResourceRequest pojo);

    /**
     * 查找表计上层用户和终端id
     */
    InstCeResourceVo selectUserTermByMeter(@Param("meterId") String meterId);

    /**
     * 查询终端下是否有表计（用于直接挂接表计和用户关系，因为有些表计是直接上来和终端关联的）
     */
    List<String> selectMeterByTermAccessGatewayId(@Param("termAccessGatewayId") String termAccessGatewayId);

    /**
     * 根据表计ID查询是否关联终端
     */
    int selectMountingTermByMeterAddr(@Param("meterNo") String meterNo, @Param("meterId") String meterId, @Param("termAddr") String termAddr);

    /**
     * 拆除表计和用能点的关系
     */
    int deleteMeterPoint(@Param("params") Map<String, Object> map);

}
