package com.gaea.iesms.bm.iot.model.request;

import com.baomidou.mybatisplus.annotation.TableName;
import com.gaea.base.core.PageQuery;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

@Data
@EqualsAndHashCode(callSuper = true)
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(value = "GmDevMeterPageRequest对象", description = "量测表计设备分页请求类")
public class CommunityConduitPageRequest extends PageQuery {

    @ApiModelProperty(value = "系统单位编号")
    private String orgNo;

    @ApiModelProperty(value = "用能客户标识")
    private String ceCustId;

    @ApiModelProperty(value = "用能客户名称")
    private String ceCustName;

    @ApiModelProperty(value = "采集终端地址")
    private String devTermCommAddr;

    @ApiModelProperty(value = "终端编号")
    private String devTermNo;

    @ApiModelProperty(value = "终端在线离线状态;1 - 在线；2 - 离线；全部为空")
    private Integer onlineOffInState;

    /**
     * 1 – 电表；2 – 水表；3 – 气表；4 – 热表；5 - 汽表；6-环境传感器；7-光伏逆变器；8-储能PMS；9-智能断路器；99 - 其他；
     */
    private String devMeterType;
}
