package com.gaea.iesms.bm.iot.model.request;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gaea.iesms.core.model.core.IesmsNormalEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 量测表计设备基础请求类
 *
 * @author Administrator
 * @version 1.0
 * @date 2023/3/27 9:15
 */
@EqualsAndHashCode(callSuper = true)
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(value = "GmDevMeterRequest对象", description = "量测表计设备基础请求类")
public class GmDevMeterRequest extends IesmsNormalEntity {

    /**
     * 终端编号
     */
    private String devTermNo;

    /**
     * 系统单位编号
     */
    @ApiModelProperty(value = "系统单位编号")
    private String orgNo;

    /**
     * 量测表计编号
     */
    @ApiModelProperty(value = "量测表计编号")
    private String devMeterNo;

    /**
     * 量测表计名称
     */
    @ApiModelProperty(value = "量测表计名称")
    private String devMeterName;

    /**
     * 量测表计状态 1 - 待装；2 - 待投；3 - 投运；4 - 故障；5 - 暂停；6 - 停运；7 - 拆除；
     */
    @ApiModelProperty(value = "量测表计状态 1 - 待装；2 - 待投；3 - 投运；4 - 故障；5 - 暂停；6 - 停运；7 - 拆除；", allowableValues = "1,2,3,4,5,6,7")
    private Integer devMeterStatus;

    /**
     * 量测表计类型 1 – 电表；2 – 水表；3 – 气表；4 – 热表；5 - 汽表；
     */
    @ApiModelProperty(value = "量测表计类型 1 – 电表；2 – 水表；3 – 气表；4 – 热表；5 - 汽表；", allowableValues = "1,2,3,4,5")
    private Integer devMeterType;

    /**
     * 量测表计运行参数
     */
    @ApiModelProperty(value = "量测表计运行参数")
    private Object devMeterRunParam;

    /**
     * 量测通信方式
     */
    @ApiModelProperty(value = "量测通信方式")
    private String devMeterCommMode;

    /**
     * 量测通信规约
     */
    @ApiModelProperty(value = "量测通信规约")
    private String devMeterCommProto;

    /**
     * 量测通信地址
     */
    @ApiModelProperty(value = "量测通信地址")
    private String devMeterCommAddr;

    /**
     * 硬件版本
     */
    @ApiModelProperty(value = "硬件版本")
    private String hardwareVersion;

    /**
     * 软件版本
     */
    @ApiModelProperty(value = "软件版本")
    private String softwareVersion;

    /**
     * 生产厂家
     */
    @ApiModelProperty(value = "生产厂家")
    private String mfrCode;

    /**
     * 生产批次
     */
    @ApiModelProperty(value = "生产批次")
    private String prodBatch;

    @ApiModelProperty(value = "生产日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date prodDate;

    /**
     * 设备型号
     */
    @ApiModelProperty(value = "设备型号")
    private String modelCode;

    /**
     * 自身倍率
     */
    @ApiModelProperty(value = "自身倍率")
    private BigDecimal selfRate;

    /**
     * CT倍率
     */
    @ApiModelProperty(value = "CT倍率")
    private BigDecimal ctRate;

    /**
     * PT倍率
     */
    @ApiModelProperty(value = "PT倍率")
    private BigDecimal ptRate;

    /**
     * 装接人
     */
    @ApiModelProperty(value = "装接人")
    private String installer;

    /**
     * 装接时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "装接时间")
    private Date installTime;

    /**
     * 装接备注
     */
    @ApiModelProperty(value = "装接备注")
    private String installRemark;

    /**
     * 投运人
     */
    @ApiModelProperty(value = "投运人")
    private String gotorunner;

    /**
     * 投运时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "投运时间")
    private Date gotorunTime;

    /**
     * 投运备注
     */
    @ApiModelProperty(value = "投运备注")
    private String gotorunRemark;

    /**
     * 停运人
     */
    @ApiModelProperty(value = "停运人")
    private String stoprunner;

    /**
     * 停运时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "停运时间")
    private Date stoprunTime;

    /**
     * 停运备注
     */
    @ApiModelProperty(value = "停运备注")
    private String stoprunRemark;

    /**
     * 拆除人
     */
    @ApiModelProperty(value = "拆除人")
    private String dismantler;

    /**
     * 拆除日期
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "拆除日期")
    private Date dismantleTime;

    /**
     * 拆除备注
     */
    @ApiModelProperty(value = "拆除备注")
    private String dismantleRemark;

    /**
     * 接入网关设备标识 采集终端投运
     */
    @ApiModelProperty(value = "接入网关设备标识 采集终端投运")
    private Long accessGatewayId;

    /**
     * 接入中继设备标识
     */
    @ApiModelProperty(value = "接入中继设备标识")
    private Long accessTrunkingId;

    /**
     * 接入量测设备标识
     */
    @ApiModelProperty(value = "接入量测设备标识")
    private Long accessMeasureId;

    /**
     * 量测点标识
     */
    @ApiModelProperty(value = "量测点标识")
    private Long measPointId;

    /**
     * 量测点性质
     */
    @ApiModelProperty(value = "量测点性质")
    private Integer measKind;

    /**
     * 量测点序号
     */
    @ApiModelProperty(value = "量测点序号")
    private Integer measSn;

    /**
     * 量测通信端口
     */
    @ApiModelProperty(value = "量测通信端口")
    private Integer measCommPort;

    /**
     * 量测通信参数
     */
    @ApiModelProperty(value = "量测通信参数")
    private Object measCommParam;

}
