package com.gaea.iesms.bm.iot.model.request;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * 装接管理--新增终端和用户关系
 *
 * @author admin
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(description = "新增终端和用户关系")
public class SaveTermCeResourceRequest implements Serializable {

    /**
     * 单位编号
     */
    private String orgNo;

    /**
     * 用户编号
     */
    private String userNo;

    /**
     * 表计状态 1 - 待装；2 - 待投；3 - 投运；4 - 故障；5 - 暂停；6 - 停运；7 - 拆除；
     */
    private String devMeterStatus;

    /**
     * 用能资源类别 1 - 用能客户；2 - 用能区域；3 - 用能容器；
     */
    private String ceResClass;

    @ApiModelProperty(value = "终端标识")
    private String termId;

    @ApiModelProperty(value = "用户id")
    private String resId;

    @ApiModelProperty(value = "安装位置")
    private String installRemark;

    @ApiModelProperty(value = "终端名称")
    private String devTermName;

    @ApiModelProperty(value = "终端地址")
    private String devTermAddr;

    @ApiModelProperty(value = "装接表标识")
    private String instPointTermId;

    @ApiModelProperty(value = "终端与表计连接的标识")
    private String termAccessGatewayId;

    /**
     * 运营商卡号
     */
    private String simNo;

}
