package com.gaea.iesms.bm.iot.model.request;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 装接管理--新增终端和表计关系
 *
 * @author admin
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(description = "新增终端和表计关系")
public class SaveTermMeterRequest implements Serializable {

    /**
     * 终端网关标识
     */
    private String termAccessGatewayId;

    /**
     * 自身倍率
     */
    private BigDecimal selfRate;
    /**
     * 单位标识
     */
    private String orgNo;
    /**
     * CT倍率
     */
    private BigDecimal ctRate;
    /**
     * PT倍率
     */
    private BigDecimal ptRate;

    private String gotoRunTime;
    private String gotoRunner;
    /**
     * 表计标识
     */
    private String meterId;
    /**
     * 装接人
     */
    private String installer;
    /**
     * 装接时间
     */
    private String installTime;
    /**
     * 用户编号
     */
    private String userNo;
    /**
     * 用能资源标识
     */
    private String ceResId;
    /**
     * 用能资源标识
     */
    private String ceResClass;
    /**
     * 终端地址
     */
    private String termAddr;
    /**
     * 表计地址
     */
    private String meterAddr;
    /**
     * 表计编号
     */
    private String meterNo;
    /**
     * 电量总
     */
    private BigDecimal electricityTotal;
    /**
     * 尖
     */
    private BigDecimal top;
    /**
     * 峰
     */
    private BigDecimal peak;
    /**
     * 平
     */
    private BigDecimal flat;
    /**
     * 谷
     */
    private BigDecimal valley;
    /**
     * 日志标识
     */
    private long id;
    /**
     * 量测表计计量起度信息;{
     * "gen_watt_paet": 1000.00,                       // 正向有功总电能示值
     * "gen_watt_pae1": 100.00,                        // 正向有功费率1电能示值
     * "gen_watt_pae2": 200.00,                        // 正向有功费率2电能示值
     * "gen_watt_pae3": 300.00,                        // 正向有功费率3电能示值
     * "gen_watt_pae4": 400.00                         // 正向有功费率4电能示值
     * }
     */
    private String devMeterStartReadingInfo;
    /**
     * 采集器标识
     */
    private long devCollectorId;
    /**
     * 采集终端标识
     */
    private String devTermId;
    /**
     * 处理状态;0 - 待处理；1 - 处理成功；2 - 处理失败；
     */
    private int handleStatus;
    /**
     * 处理结果
     */
    private String handleResult;
    /**
     * 排序序号
     */
    private int sortSn;
    /**
     * 是否有效
     */
    private boolean isValid = true;
    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;
    /**
     * 创建时间;为0表示为空
     */
    private long gmtCreate;
    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;
    /**
     * 更新时间;为0表示为空
     */
    private long gmtModified;
    /**
     * 版本号;用于乐观锁
     */
    private int version;
    /**
     * 表计标识
     */
    private String newMeterId;
    /**
     * 电量总
     */
    private BigDecimal newElectricityTotal;
    /**
     * 尖
     */
    private BigDecimal newTop;
    /**
     * 峰
     */
    private BigDecimal newPeak;
    /**
     * 平
     */
    private BigDecimal newFlat;
    /**
     * 谷
     */
    private BigDecimal newValley;

    /**
     * 新量测表计计量起度信息;{
     * "gen_watt_paet": 1000.00,                       // 正向有功总电能示值
     * "gen_watt_pae1": 100.00,                        // 正向有功费率1电能示值
     * "gen_watt_pae2": 200.00,                        // 正向有功费率2电能示值
     * "gen_watt_pae3": 300.00,                        // 正向有功费率3电能示值
     * "gen_watt_pae4": 400.00                         // 正向有功费率4电能示值
     * }
     */
    private String newDevMeterStartReadingInfo;
    /**
     * 表计状态
     */
    private String devMeterStatus;

    /**
     * 接入量测设备标识
     */
    private Long accessMeasureId;

    /**
     * 量测点标识
     */
    private Long measPointId;

    /**
     * 表计类型
     */
    private String devMeterType;
    /**
     * 表计名称
     */
    private String devMeterName;

}
