package com.gaea.iesms.bm.iot.model.response;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * 终端表计列表
 * @author admin
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(description = "终端表计列表")
public class CommunityConduitMeterInfoVo implements Serializable {

    @ApiModelProperty(value = "表计id")
    private String meterId;

    @ApiModelProperty(value = "表计地址")
    private String devMeterCommAddr;

    @ApiModelProperty(value = "表计名称")
    private String devMeterName;

    @ApiModelProperty(value = "表计编号")
    private String devMeterNo;

    @ApiModelProperty(value = "生产厂家")
    private String mfrCode;

    @ApiModelProperty(value = "设备型号")
    private String modelCode;

    @ApiModelProperty(value = "终端编号")
    private String devTermNo;

    @ApiModelProperty(value = "终端地址")
    private String devTermCommAddr;

    @ApiModelProperty(value = "终端名称")
    private String devTermName;

    @ApiModelProperty(value = "表计在线离线状态;1 - 在线；2 - 离线")
    private Integer onlineOffInState;

    @ApiModelProperty(value = "终端在线离线状态;1 - 在线；2 - 离线")
    private Integer termOnlineOffInState;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "最后通讯时间")
    private Date lastCommunityTime;

}
