package com.gaea.iesms.bm.iot.model.response;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 通讯工况返回数据类
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(description = "通讯工况返回数据类")
public class CommunityConduitVo implements Serializable {

    @ApiModelProperty(value = "终端id")
    private String devTermId;

    @ApiModelProperty(value = "用户标识")
    private String ceCustId;

    @ApiModelProperty(value = "用户名称")
    private String ceCustName;

    @ApiModelProperty(value = "采集终端编号")
    private String devTermNo;

    @ApiModelProperty(value = "采集终端名称")
    private String devTermName;

    @ApiModelProperty(value = "采集终端地址")
    private String devTermCommAddr;

    @ApiModelProperty(value = "采集终端状态;1 - 待装；2 - 待投；3 - 投运；4 - 故障；5 - 暂停；6 - 停运；7 - 拆除；")
    private Integer devTermStatus;

    @ApiModelProperty(value = "生产厂家")
    private String mfrCode;
    @ApiModelProperty(value = "生产厂家名称")
    private String mfrName;

    @ApiModelProperty(value = "设备（终端）型号")
    private String modelCode;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "最后通讯时间")
    private Date lastCommunityTime;

    @ApiModelProperty(value = "表计在线数量")
    private Integer meterOnlineCount;

    @ApiModelProperty(value = "表计离线数量")
    private Integer meterOfflineCount;

    @ApiModelProperty(value = "表计在线列表")
    private List<CommunityConduitMeterInfoVo> meterOnlineList;

    @ApiModelProperty(value = "表计离线列表")
    private List<CommunityConduitMeterInfoVo> meterOfflineList;

    private Long gmtMessageUp;

    @ApiModelProperty(value = "终端在线/离线状态")
    private String termStatus;
}
