package com.gaea.iesms.bm.iot.model.response;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gaea.base.typehandler.JsonObjectTypeHandler;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 量测表计设备返回数据类
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(description = "量测表计设备返回数据类")
public class GmDevMeterVo {

    @ApiModelProperty(value = "量测表计标识")
    private String id;

    @ApiModelProperty(value = "用户标识")
    private String ceCustId;

    @ApiModelProperty(value = "用户名称")
    private String ceCustName;

    @ApiModelProperty(value = "所属对象")
    private String belongObject;

    @ApiModelProperty(value = "采集终端编号")
    private String devTermNo;

    @ApiModelProperty(value = "采集终端地址")
    private String devTermCommAddr;

    @ApiModelProperty(value = "采集终端名称")
    private String devTermName;

    @ApiModelProperty(value = "量测表计编号")
    private String devMeterNo;

    @ApiModelProperty(value = "量测表计名称")
    private String devMeterName;

    @ApiModelProperty(value = "量测通信地址")
    private String devMeterCommAddr;

    @ApiModelProperty(value = "设备（表计）型号")
    private String modelCode;

    @ApiModelProperty(value = "量测表计状态 1 - 待装；2 - 待投；3 - 投运；4 - 故障；5 - 暂停；6 - 停运；7 - 拆除；", allowableValues = "1,2,3,4,5,6,7")
    private String devMeterStatus;

    @ApiModelProperty(value = "CT倍率")
    private BigDecimal ctRate;

    @ApiModelProperty(value = "PT倍率")
    private BigDecimal ptRate;

    @ApiModelProperty(value = "倍率")
    private BigDecimal selfRate;

    @ApiModelProperty(value = "生产厂家")
    private String mfrCode;

    @ApiModelProperty(value = "生产厂家名称")
    private String mfrName;

    @ApiModelProperty(value = "生产批次")
    private String prodBatch;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "投运时间")
    private Date gotorunTime;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty(value = "生产日期")
    private Date prodDate;

    /**
     * 量测通信参数
     */
    @TableField(value = "meas_comm_param", typeHandler = JsonObjectTypeHandler.class)
    private Object measCommParam;

    @TableField(value = "dev_meter_run_param", typeHandler = JsonObjectTypeHandler.class)
    private Object devMeterRunParam;

    /**
     * 接入网关设备标识 采集终端投运后，后台自动注册采集平台接入网关设备，注册成功后回填入接入网关设备标识
     */
    private Long accessGatewayId;

    /**
     * 量测通信方式
     */
    private String devMeterCommMode;

    /**
     * 量测通信规约
     */
    private String devMeterCommProto;

    /**
     * 硬件版本
     */
    private String hardwareVersion;

    /**
     * 软件版本
     */
    private String softwareVersion;

    /**
     * 量测点
     */
    private String measPointId;

    @ApiModelProperty(value = "量测设备类型 1 – 电表；2 – 水表；3 – 气表；4 – 热表；5 - 汽表；6-环境传感器；7-光伏逆变器；8-储能PCS；9-智能断路器；99 - 其他；")
    private String devMeterType;

    @ApiModelProperty(value = "量测表计状态名称")
    private String devMeterTypeName;

}
