package com.gaea.iesms.bm.iot.model.response;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.util.Date;

/**
 *采集终端设备返回数据类
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(description = "采集终端设备返回数据类")
public class GmDevTermVo {

    @ApiModelProperty(value = "采集终端标识")
    private String id;

    @ApiModelProperty(value = "采集终端编号")
    private String devTermNo;

    @ApiModelProperty(value = "采集终端名称")
    private String devTermName;

    @ApiModelProperty(value = "采集终端状态;1 - 待装；2 - 待投；3 - 投运；4 - 故障；5 - 暂停；6 - 停运；7 - 拆除；")
    private String devTermStatus;

    @ApiModelProperty(value = "采集终端通讯地址")
    private String devTermCommAddr;

    @ApiModelProperty(value = "生产厂家")
    private String mfrCode;

    @ApiModelProperty(value = "生产厂家名称")
    private String mfrName;

    @ApiModelProperty(value = "设备型号")
    private String modelCode;

    @ApiModelProperty(value = "SIM卡号")
    private String simNo;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "投运时间")
    private Date gotorunTime;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "安装日期")
    private Date prodDate;

    @ApiModelProperty(value = "安装位置")
    private String installRemark;

    @ApiModelProperty(value = "接入网关设备标识；采集终端投运后，后台自动注册采集平台接入网关设备，注册成功后回填入接入网关设备标识及量测点标识")
    private Long accessGatewayId;

    @ApiModelProperty(value = "量测点标识；采集终端投运后，后台自动注册采集平台接入网关设备，注册成功后回填入接入网关设备标识及量测点标识")
    private Long measPointId;

    @ApiModelProperty(value = "是否关联表计")
    private String assocMeter;

    @ApiModelProperty(value = "客户名称")
    private String ceCustName;
    @ApiModelProperty(value = "客户标识")
    private String ceCustId;

    @ApiModelProperty(value = "生产批次")
    private String prodBatch;

}
